/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.curio;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.NBTTool;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ParachuteItem
extends Item
implements ICurioItem {
    public static final String TAG_OPEN = "Open";

    public ParachuteItem() {
        super(new Item.Properties().stacksTo(1).durability(600));
    }

    public boolean isValidRepairItem(@NotNull ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.is(Items.PHANTOM_MEMBRANE);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity()).flatMap(c -> c.findFirstCurio((Item)this)).isEmpty();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        block6: {
            Level level;
            Player player;
            LivingEntity entity;
            block8: {
                CompoundTag tag;
                block7: {
                    entity = slotContext.entity();
                    tag = NBTTool.getTag(stack);
                    if (!tag.getBoolean(TAG_OPEN)) break block6;
                    if (entity.onGround() || entity.isInWater() || entity.isFallFlying() || entity.getVehicle() != null) break block7;
                    if (!(entity instanceof Player)) break block8;
                    player = (Player)entity;
                    if (!player.getAbilities().flying) break block8;
                }
                tag.putBoolean(TAG_OPEN, false);
                NBTTool.saveTag(stack, tag);
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)ModSounds.PARACHUTE_CLOSE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (entity instanceof Player) {
                player = (Player)entity;
                if (player.level().isClientSide) {
                    player.addDeltaMovement(new Vec3(player.getLookAngle().x, 0.0, player.getLookAngle().z).normalize().scale(0.05));
                    player.setDeltaMovement(player.getDeltaMovement().multiply(1.03, 0.75, 1.03));
                }
            }
            if (entity.tickCount % 40 == 0 && (level = entity.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                stack.hurtAndBreak(1, serverLevel, entity, item -> {});
            }
            entity.resetFallDistance();
        }
    }

    public static boolean isParachuteOpen(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(c -> c.findFirstCurio((Item)ModItems.PARACHUTE.get()).map(slotResult -> NBTTool.getTag(slotResult.stack()).getBoolean(TAG_OPEN)).orElse(false)).orElse(false);
    }

    public static boolean isParachuteVisible(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(c -> c.findFirstCurio((Item)ModItems.PARACHUTE.get()).map(slotResult -> slotResult.slotContext().visible()).orElse(false)).orElse(false);
    }
}

