/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.special;

import com.atsuishio.superbwarfare.client.renderer.gun.RepairToolItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.mixin.ICustomKnockback;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.BatteryItem;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.world.phys.EntityResult;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class RepairToolItem
extends GunGeoItem {
    public RepairToolItem() {
        super(new Item.Properties().rarity(Rarity.COMMON));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return RepairToolItemRenderer::new;
    }

    @Override
    public void onRayHitBlock(Entity shooter, ServerLevel level, @Nullable Entity target, @NotNull GunData data, Vec3 shootDirection, BlockHitResult result, @NotNull Vec3 pos) {
        super.onRayHitBlock(shooter, level, target, data, shootDirection, result, pos);
        BlockPos blockPos = result.getBlockPos();
        BlockState state = level.getBlockState(blockPos);
        this.summonRayHitParticle(level, state, pos, shootDirection.scale(-1.0).normalize());
    }

    @Override
    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack cell : player.getInventory().items) {
                IEnergyStorage stackStorage;
                if (!(cell.getItem() instanceof BatteryItem) || (stackStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null) continue;
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(Capabilities.EnergyStorage.ITEM);
                if (cellStorage == null) continue;
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stackStorage.receiveEnergy(stackEnergyNeed, false);
                }
                cellStorage.extractEnergy(stackEnergyNeed, false);
            }
        }
    }

    @Override
    public SoundEvent getRayHitBlockSound(GunData data) {
        return (SoundEvent)ModSounds.REPAIRING.get();
    }

    @Override
    public SoundEvent getRayHitEntitySound(GunData data) {
        return (SoundEvent)ModSounds.REPAIRING.get();
    }

    @Override
    public void onRayHitEntity(Entity shooter, ServerLevel level, @NotNull GunData data, EntityResult result, Vec3 shootPosition, Vec3 shootDirection) {
        Entity target = result.getEntity();
        Vec3 pos = result.getHitPos();
        level.playSound(null, result.getHitPos().x, result.getHitPos().y, result.getHitPos().z, this.getRayHitEntitySound(data), SoundSource.PLAYERS, 0.7f, (float)((2.0 * Math.random() - 1.0) * (double)0.05f + 1.0));
        if (target instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)target;
            Entity lastDriver = EntityFindUtil.findEntity((Level)level, (String)vehicle.getEntityData().get(VehicleEntity.LAST_DRIVER_UUID));
            if (lastDriver != null && !SeekTool.IN_SAME_TEAM.test(shooter, lastDriver) && lastDriver.getTeam() != null || shooter.isShiftKeyDown()) {
                vehicle.hurt(ModDamageTypes.causeRepairToolDamage(level.registryAccess(), shooter), 0.5f);
                if (shooter instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)shooter;
                    player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 0.1f, 1.0f);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                vehicle.heal(0.5f + 0.0025f * vehicle.getMaxHealth());
            }
            this.summonRayHitParticle(level, null, pos, shootDirection.scale(-1.0).normalize());
        } else if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            if (target.getType().is(ModTags.EntityTypes.CAN_REPAIR) && !shooter.isShiftKeyDown()) {
                living.heal(0.5f + 0.0025f * living.getMaxHealth());
            } else {
                ICustomKnockback iCustomKnockback = ICustomKnockback.getInstance(living);
                iCustomKnockback.superbWarfare$setKnockbackStrength(0.0);
                float damage = (float)data.compute().damage;
                DamageHandler.doDamage((Entity)living, ModDamageTypes.causeRepairToolDamage(level.registryAccess(), shooter), damage);
                target.invulnerableTime = 0;
                iCustomKnockback.superbWarfare$resetKnockbackStrength();
                if (shooter instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)shooter;
                    player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 0.1f, 1.0f);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            this.summonRayHitParticle(level, null, pos, shootDirection.scale(-1.0).normalize());
        }
    }

    public void summonRayHitParticle(ServerLevel serverLevel, @Nullable BlockState state, Vec3 pos, Vec3 dir) {
        int i;
        if (state != null) {
            BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.BLOCK, state);
            for (int i2 = 0; i2 < 1; ++i2) {
                Vec3 vec3 = this.randomVec(dir, 40.0);
                ParticleTool.sendParticle(serverLevel, particleData, pos.x + 0.05 * (double)i2 * dir.x, pos.y + 0.05 * (double)i2 * dir.y, pos.z + 0.05 * (double)i2 * dir.z, 0, vec3.x, vec3.y, vec3.z, 10.0, true);
            }
        }
        for (i = 0; i < 3; ++i) {
            Vec3 vec3 = this.randomVec(dir, 20.0);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 0, vec3.x, vec3.y, vec3.z, 0.05, true);
        }
        for (i = 0; i < 2; ++i) {
            Vec3 vec3 = this.randomVec(dir, 80.0);
            ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), pos.x, pos.y, pos.z, 0, vec3.x, vec3.y, vec3.z, 0.2 + 0.1 * Math.random(), true);
        }
    }
}

