/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.subdata.Perks;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModMenuTypes;
import com.atsuishio.superbwarfare.item.PerkItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ReforgingTableMenu
extends AbstractContainerMenu {
    protected final Container container;
    protected final ContainerLevelAccess access;
    public static final int INPUT_SLOT = 0;
    public static final int AMMO_PERK_SLOT = 1;
    public static final int FUNC_PERK_SLOT = 2;
    public static final int DAMAGE_PERK_SLOT = 3;
    public static final int RESULT_SLOT = 4;
    public static final int MAX_PERK_LEVEL = 20;
    public static final int MAX_UPGRADE_POINT = 100;
    public final DataSlot ammoPerkLevel = DataSlot.standalone();
    public final DataSlot funcPerkLevel = DataSlot.standalone();
    public final DataSlot damagePerkLevel = DataSlot.standalone();
    public static final int X_OFFSET = 0;
    public static final int Y_OFFSET = 11;

    public ReforgingTableMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(5), ContainerLevelAccess.NULL);
    }

    public ReforgingTableMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess access) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(5), access);
    }

    public ReforgingTableMenu(int pContainerId, Inventory inventory, Container container, ContainerLevelAccess pContainerLevelAccess) {
        super(ModMenuTypes.REFORGING_TABLE_MENU.get(), pContainerId);
        ReforgingTableMenu.checkContainerSize((Container)container, (int)5);
        this.container = container;
        this.access = pContainerLevelAccess;
        this.ammoPerkLevel.set(0);
        this.funcPerkLevel.set(0);
        this.damagePerkLevel.set(0);
        this.addDataSlot(this.ammoPerkLevel);
        this.addDataSlot(this.funcPerkLevel);
        this.addDataSlot(this.damagePerkLevel);
        this.addSlot(new InputSlot(container, 0, 20, 22));
        this.addSlot(new PerkSlot(container, 1, Perk.Type.AMMO, 80, 25));
        this.addSlot(new PerkSlot(container, 2, Perk.Type.FUNCTIONAL, 80, 45));
        this.addSlot(new PerkSlot(container, 3, Perk.Type.DAMAGE, 80, 65));
        this.addSlot(new ResultSlot(container, 4, 142, 45));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18 + 0, 84 + i * 18 + 11));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inventory, k, 8 + k * 18 + 0, 153));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (pIndex == 0) {
                this.onTakeGun(stack);
                if (!this.moveItemStackTo(stack, 5, 41, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (pIndex >= 1 && pIndex <= 3) {
                this.onTakePerk(stack);
                if (!this.moveItemStackTo(stack, 5, 41, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (pIndex == 4) {
                if (!this.moveItemStackTo(stack, 4, 40, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (stack.getItem() instanceof GunItem) {
                if (!this.moveItemStackTo(stack, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                Item item = stack.getItem();
                if (item instanceof PerkItem) {
                    PerkItem perkItem = (PerkItem)item;
                    Perk.Type type = perkItem.getPerk().type;
                    if (type == Perk.Type.AMMO ? !this.moveItemStackTo(stack, 1, 2, false) : (type == Perk.Type.FUNCTIONAL ? !this.moveItemStackTo(stack, 2, 3, false) : type == Perk.Type.DAMAGE && !this.moveItemStackTo(stack, 3, 4, false))) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, stack);
        }
        return itemstack;
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return (Boolean)this.access.evaluate((level, pos) -> level.getBlockState(pos).is((Block)ModBlocks.REFORGING_TABLE.get()) && pPlayer.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    @Nullable
    public ItemStack getGunStack() {
        ItemStack gun = this.container.getItem(0);
        if (gun.getItem() instanceof GunItem) {
            return gun;
        }
        return null;
    }

    @Nullable
    public GunData getGunData() {
        ItemStack gun = this.getGunStack();
        return gun == null ? null : GunData.from(gun);
    }

    public void removed(@NotNull Player pPlayer) {
        this.access.execute((level, pos) -> {
            ItemStack gun = this.container.getItem(0);
            ItemStack copy = gun.copy();
            for (int i = 0; i < this.container.getContainerSize(); ++i) {
                Item patt0$temp;
                ItemStack itemstack = this.container.getItem(i);
                if (copy.getItem() instanceof GunItem && (patt0$temp = itemstack.getItem()) instanceof PerkItem) {
                    PerkItem perkItem = (PerkItem)patt0$temp;
                    if (!copy.isEmpty() && GunData.from((ItemStack)copy).perk.getLevel(perkItem) > 0) continue;
                }
                if (!itemstack.isEmpty()) {
                    pPlayer.getInventory().placeItemBackInInventory(itemstack);
                }
                this.container.removeItemNoUpdate(i);
            }
        });
    }

    public int availableLevel() {
        GunData data = this.getGunData();
        if (data == null) {
            return 0;
        }
        int totalLevel = data.level.get();
        totalLevel -= Math.max(0, this.ammoPerkLevel.get() - 1);
        totalLevel -= Math.max(0, this.funcPerkLevel.get() - 1);
        return Math.max(0, totalLevel -= Math.max(0, this.damagePerkLevel.get() - 1));
    }

    public void setPerkLevel(Perk.Type type, boolean upgrade, boolean isCreative) {
        if (upgrade && this.availableLevel() <= 0 && !isCreative) {
            return;
        }
        if (!upgrade && this.availableLevel() >= 100 && !isCreative) {
            return;
        }
        switch (type) {
            case AMMO: {
                this.ammoPerkLevel.set(upgrade ? Math.min(20, this.ammoPerkLevel.get() + 1) : Math.max(1, this.ammoPerkLevel.get() - 1));
                break;
            }
            case FUNCTIONAL: {
                this.funcPerkLevel.set(upgrade ? Math.min(20, this.funcPerkLevel.get() + 1) : Math.max(1, this.funcPerkLevel.get() - 1));
                break;
            }
            case DAMAGE: {
                this.damagePerkLevel.set(upgrade ? Math.min(20, this.damagePerkLevel.get() + 1) : Math.max(1, this.damagePerkLevel.get() - 1));
            }
        }
    }

    public void generateResult() {
        ItemStack gun = this.getGunStack();
        if (gun == null) {
            return;
        }
        ItemStack ammo = this.container.getItem(1);
        ItemStack func = this.container.getItem(2);
        ItemStack damage = this.container.getItem(3);
        if (ammo.isEmpty() && func.isEmpty() && damage.isEmpty()) {
            return;
        }
        ItemStack result = gun.copy();
        GunData data = GunData.from(result);
        List.of(ammo, func, damage).forEach(item -> {
            Item patt0$temp;
            if (!item.isEmpty() && (patt0$temp = item.getItem()) instanceof PerkItem) {
                PerkItem perkItem = (PerkItem)patt0$temp;
                if (GunData.from(this.container.getItem(0)).canApplyPerk(perkItem.getPerk())) {
                    Perks perks = data.perk;
                    Perk perk = perkItem.getPerk();
                    perks.set(new PerkInstance(perk, switch (perkItem.getPerk().type) {
                        default -> throw new MatchException(null, null);
                        case Perk.Type.AMMO -> (short)this.ammoPerkLevel.get();
                        case Perk.Type.FUNCTIONAL -> (short)this.funcPerkLevel.get();
                        case Perk.Type.DAMAGE -> (short)this.damagePerkLevel.get();
                    }));
                    this.container.setItem(switch (perkItem.getPerk().type) {
                        default -> throw new MatchException(null, null);
                        case Perk.Type.AMMO -> 1;
                        case Perk.Type.FUNCTIONAL -> 2;
                        case Perk.Type.DAMAGE -> 3;
                    }, ItemStack.EMPTY);
                }
            }
        });
        data.save();
        this.ammoPerkLevel.set(0);
        this.funcPerkLevel.set(0);
        this.damagePerkLevel.set(0);
        this.container.setItem(0, ItemStack.EMPTY);
        this.container.setItem(4, result);
        this.container.setChanged();
    }

    private void onTakePerk(ItemStack perk) {
        ItemStack gun = this.container.getItem(0);
        if (!(gun.getItem() instanceof GunItem)) {
            return;
        }
        Item item = perk.getItem();
        if (item instanceof PerkItem) {
            PerkItem perkItem = (PerkItem)item;
            switch (perkItem.getPerk().type) {
                case AMMO: {
                    this.ammoPerkLevel.set(0);
                    break;
                }
                case FUNCTIONAL: {
                    this.funcPerkLevel.set(0);
                    break;
                }
                case DAMAGE: {
                    this.damagePerkLevel.set(0);
                }
            }
            GunData inputData = GunData.from(gun);
            short level = inputData.perk.getLevel(perkItem);
            if (level <= 0) {
                return;
            }
            ItemStack output = gun.copy();
            GunData outputData = GunData.from(output);
            outputData.perk.remove(perkItem.getPerk());
            outputData.save();
            inputData.save();
            this.container.setItem(0, output);
            this.container.setChanged();
        }
    }

    private void onPlacePerk(ItemStack pStack) {
        Item item = pStack.getItem();
        if (!(item instanceof PerkItem)) {
            return;
        }
        PerkItem perkItem = (PerkItem)item;
        switch (perkItem.getPerk().type) {
            case AMMO: {
                this.ammoPerkLevel.set(1);
                break;
            }
            case FUNCTIONAL: {
                this.funcPerkLevel.set(1);
                break;
            }
            case DAMAGE: {
                this.damagePerkLevel.set(1);
            }
        }
    }

    private void onPlaceGun(ItemStack stack) {
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = data.perk.getInstance(type);
            if (perkInstance == null) continue;
            switch (type) {
                case AMMO: {
                    this.ammoPerkLevel.set((int)perkInstance.level());
                    break;
                }
                case FUNCTIONAL: {
                    this.funcPerkLevel.set((int)perkInstance.level());
                    break;
                }
                case DAMAGE: {
                    this.damagePerkLevel.set((int)perkInstance.level());
                }
            }
            Item ammoPerkItem = (Item)perkInstance.perk().getItem().get();
            this.container.setItem(switch (type) {
                default -> throw new MatchException(null, null);
                case Perk.Type.AMMO -> 1;
                case Perk.Type.FUNCTIONAL -> 2;
                case Perk.Type.DAMAGE -> 3;
            }, ammoPerkItem.getDefaultInstance());
        }
        this.container.setChanged();
        this.broadcastChanges();
    }

    private void onTakeGun(ItemStack stack) {
        ItemStack damage;
        ItemStack func;
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkItem perkItem;
            Item item;
            int slot;
            Perk perk = data.perk.get(type);
            switch (type) {
                default: {
                    throw new MatchException(null, null);
                }
                case AMMO: {
                    int n = 1;
                    break;
                }
                case FUNCTIONAL: {
                    int n = 2;
                    break;
                }
                case DAMAGE: {
                    int n = slot = 3;
                }
            }
            if (perk == null || !((item = this.container.getItem(slot).getItem()) instanceof PerkItem) || (perkItem = (PerkItem)item).getPerk() != perk) continue;
            this.container.setItem(slot, ItemStack.EMPTY);
        }
        this.ammoPerkLevel.set(0);
        this.funcPerkLevel.set(0);
        this.damagePerkLevel.set(0);
        ItemStack ammo = this.container.getItem(1);
        if (ammo != ItemStack.EMPTY) {
            this.moveItemStackTo(ammo, 5, 41, false);
        }
        if ((func = this.container.getItem(2)) != ItemStack.EMPTY) {
            this.moveItemStackTo(func, 5, 41, false);
        }
        if ((damage = this.container.getItem(3)) != ItemStack.EMPTY) {
            this.moveItemStackTo(damage, 5, 41, false);
        }
        this.container.setChanged();
    }

    @Nullable
    public ItemStack getPerkItemBySlot(Perk.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Perk.Type.AMMO -> this.container.getItem(1);
            case Perk.Type.FUNCTIONAL -> this.container.getItem(2);
            case Perk.Type.DAMAGE -> this.container.getItem(3);
        };
    }

    class InputSlot
    extends Slot {
        public InputSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean mayPlace(@NotNull ItemStack pStack) {
            if (pStack.getItem() instanceof GunItem) {
                ItemStack ammoPerk = this.container.getItem(1);
                ItemStack funcPerk = this.container.getItem(2);
                ItemStack damagePerk = this.container.getItem(3);
                boolean flag1 = ammoPerk.isEmpty();
                boolean flag2 = funcPerk.isEmpty();
                boolean flag3 = damagePerk.isEmpty();
                return flag1 && flag2 && flag3 && this.container.getItem(4).isEmpty() && this.container.getItem(0).isEmpty();
            }
            return false;
        }

        public int getMaxStackSize() {
            return 1;
        }

        public void onTake(@NotNull Player pPlayer, @NotNull ItemStack pStack) {
            super.onTake(pPlayer, pStack);
            ReforgingTableMenu.this.onTakeGun(pStack);
        }

        public void setByPlayer(@NotNull ItemStack pStack) {
            ReforgingTableMenu.this.onPlaceGun(pStack);
            super.setByPlayer(pStack);
        }
    }

    class PerkSlot
    extends Slot {
        public Perk.Type type;

        public PerkSlot(Container pContainer, int pSlot, Perk.Type type, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
            this.type = type;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean mayPlace(@NotNull ItemStack pStack) {
            int slot = switch (this.type) {
                default -> throw new MatchException(null, null);
                case Perk.Type.AMMO -> 1;
                case Perk.Type.FUNCTIONAL -> 2;
                case Perk.Type.DAMAGE -> 3;
            };
            Item item = pStack.getItem();
            if (!(item instanceof PerkItem)) return false;
            PerkItem perkItem = (PerkItem)item;
            if (perkItem.getPerk().type != this.type) return false;
            if (this.container.getItem(0).isEmpty()) return false;
            if (!(this.container.getItem(0).getItem() instanceof GunItem)) return false;
            if (!GunData.from(this.container.getItem(0)).canApplyPerk(perkItem.getPerk())) return false;
            if (!this.container.getItem(slot).isEmpty()) return false;
            return true;
        }

        public int getMaxStackSize() {
            return 1;
        }

        public void onTake(@NotNull Player pPlayer, @NotNull ItemStack pStack) {
            ReforgingTableMenu.this.onTakePerk(pStack);
            super.onTake(pPlayer, pStack);
        }

        public void setByPlayer(@NotNull ItemStack pStack) {
            ReforgingTableMenu.this.onPlacePerk(pStack);
            super.setByPlayer(pStack);
        }
    }

    static class ResultSlot
    extends Slot {
        public ResultSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean mayPlace(@NotNull ItemStack pStack) {
            return false;
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

