/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.screens.VehicleAssemblingScreen;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.network.message.receive.FinishAssemblingVehicleMessage;
import com.atsuishio.superbwarfare.network.message.receive.SoundClientMessage;
import java.util.Objects;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ClientPacketHandler {
    public static void handleResetCameraType() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        Minecraft.getInstance().options.setCameraType(Objects.requireNonNullElse(ClientEventHandler.lastCameraType, CameraType.FIRST_PERSON));
    }

    public static void handleFinishAssemblingVehicleMessage(FinishAssemblingVehicleMessage message) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (player.containerMenu.containerId != message.containerId()) {
            return;
        }
        Screen screen = minecraft.screen;
        if (screen instanceof VehicleAssemblingScreen) {
            VehicleAssemblingScreen screen2 = (VehicleAssemblingScreen)screen;
            screen2.finishAssembling();
        }
    }

    public static void handleSoundClientMessage(SoundClientMessage message) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.getUUID().equals(message.uuid()) && (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle)) {
            return;
        }
        SoundEvent sound = SoundEvent.createVariableRangeEvent((ResourceLocation)message.location());
        double distance = player.position().distanceTo(new Vec3(message.pos()));
        int time = (int)(distance / 17.0);
        if (time == 0) {
            player.level().playSound((Player)player, (double)message.pos().x(), (double)message.pos().y(), (double)message.pos().z(), sound, SoundSource.BLOCKS, message.radius(), message.pitch());
        } else {
            Mod.queueClientWork(time, () -> ClientPacketHandler.lambda$handleSoundClientMessage$0((Player)player, message, sound));
        }
    }

    private static /* synthetic */ void lambda$handleSoundClientMessage$0(Player player, SoundClientMessage message, SoundEvent sound) {
        player.level().playSound(player, (double)message.pos().x(), (double)message.pos().y(), (double)message.pos().z(), sound, SoundSource.BLOCKS, message.radius(), message.pitch());
    }
}

