/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.Mod;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record ClientSetMotionMessage(Vector3f motion, Vector3f position) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientSetMotionMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("client_set_motion"));
    public static final StreamCodec<ByteBuf, ClientSetMotionMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VECTOR3F, ClientSetMotionMessage::motion, (StreamCodec)ByteBufCodecs.VECTOR3F, ClientSetMotionMessage::position, ClientSetMotionMessage::new);

    @OnlyIn(value=Dist.CLIENT)
    public static void handler(ClientSetMotionMessage message) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null) {
            player.setPos((double)message.position().x, (double)message.position().y, (double)message.position().z);
            player.setDeltaMovement((double)message.motion().x, (double)message.motion().y, (double)message.motion().z);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

