/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.client.KillMessageConfig;
import com.atsuishio.superbwarfare.event.KillMessageHandler;
import com.atsuishio.superbwarfare.tools.LivingKillRecord;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class LivingGunKillMessage
implements CustomPacketPayload {
    private final int attackerId;
    private final int targetId;
    private final boolean headshot;
    private final ResourceLocation location;
    public static final CustomPacketPayload.Type<LivingGunKillMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("player_gun_kill"));
    public static final StreamCodec<ByteBuf, LivingGunKillMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, LivingGunKillMessage::getAttackerId, (StreamCodec)ByteBufCodecs.INT, LivingGunKillMessage::getTargetId, (StreamCodec)ByteBufCodecs.BOOL, LivingGunKillMessage::isHeadshot, (StreamCodec)ResourceLocation.STREAM_CODEC, LivingGunKillMessage::getLocation, LivingGunKillMessage::new);

    public int getAttackerId() {
        return this.attackerId;
    }

    public boolean isHeadshot() {
        return this.headshot;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public ResourceKey<DamageType> getDamageType() {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)this.location);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public LivingGunKillMessage(int attackerId, int targetId, boolean headshot, ResourceKey<DamageType> damageType) {
        this.attackerId = attackerId;
        this.targetId = targetId;
        this.headshot = headshot;
        this.location = damageType.location();
    }

    public LivingGunKillMessage(int attackerId, int targetId, boolean headshot, ResourceLocation location) {
        this.attackerId = attackerId;
        this.targetId = targetId;
        this.headshot = headshot;
        this.location = location;
    }

    public static void handler(LivingGunKillMessage message, IPayloadContext context) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            OwnableEntity ownableEntity;
            Player player;
            LivingEntity living;
            Entity entity = level.getEntity(message.attackerId);
            Object attacker = entity instanceof LivingEntity ? ((living = (LivingEntity)entity) instanceof Player ? (player = (Player)living) : (living instanceof OwnableEntity && (ownableEntity = (OwnableEntity)living).getOwner() instanceof Player ? living : null)) : null;
            Entity target = level.getEntity(message.targetId);
            if (attacker != null && target != null) {
                ResourceKey<DamageType> type = message.getDamageType();
                if (KillMessageHandler.QUEUE.size() >= (Integer)KillMessageConfig.KILL_MESSAGE_COUNT.get()) {
                    KillMessageHandler.QUEUE.poll();
                }
                KillMessageHandler.QUEUE.offer(new LivingKillRecord((LivingEntity)attacker, target, attacker.getMainHandItem(), message.headshot, type));
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

