/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record AdjustMortarAngleMessage(double scroll) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AdjustMortarAngleMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("adjust_mortar_angle"));
    public static final StreamCodec<ByteBuf, AdjustMortarAngleMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, AdjustMortarAngleMessage::scroll, AdjustMortarAngleMessage::new);

    public static void handler(AdjustMortarAngleMessage message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        Entity looking = TraceTool.findLookingEntity((Entity)player, 6.0);
        if (looking == null) {
            return;
        }
        if (looking instanceof MortarEntity) {
            MortarEntity mortar = (MortarEntity)looking;
            mortar.getEntityData().set(MortarEntity.TARGET_PITCH, (Object)Float.valueOf((float)Mth.clamp((double)((double)((Float)mortar.getEntityData().get(MortarEntity.TARGET_PITCH)).floatValue() + 0.5 * message.scroll), (double)-89.0, (double)-20.0)));
        }
        SoundTool.playLocalSound(player, (SoundEvent)ModSounds.ADJUST_FOV.get(), 1.0f, 0.7f);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

