/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.FireModeInfo;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SoundTool;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record FireModeMessage(boolean forward) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FireModeMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("fire_mode"));
    public static final StreamCodec<ByteBuf, FireModeMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, FireModeMessage::forward, FireModeMessage::new);

    public static void handler(FireModeMessage message, IPayloadContext context) {
        FireModeMessage.changeFireMode(message, (ServerPlayer)context.player());
    }

    public static void changeFireMode(FireModeMessage message, ServerPlayer player) {
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        int selectedFireMode = data.selectedFireMode.get();
        List<FireModeInfo> fireModes = data.compute().availableFireModes();
        if (fireModes.size() > 1) {
            int mode = (selectedFireMode + (message.forward() ? -1 : 1) + fireModes.size()) % fireModes.size();
            data.selectedFireMode.set(mode);
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.FIRE_RATE.get());
            return;
        }
        if (!(stack.getItem() != ModItems.SENTINEL.get() || player.isSpectator() || player.getCooldowns().isOnCooldown(stack.getItem()) || GunData.from((ItemStack)stack).reload.time() != 0 || GunData.from(stack).charging())) {
            for (ItemStack cell : player.getInventory().items) {
                IEnergyStorage cap;
                if (!cell.is((Item)ModItems.CELL.get()) || (cap = (IEnergyStorage)cell.getCapability(Capabilities.EnergyStorage.ITEM)) == null || cap.getEnergyStored() <= 0) continue;
                data.charge.starter.markStart();
            }
        }
        if (stack.getItem() == ModItems.JAVELIN.get()) {
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_OUT.get());
        }
        data.save();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

