/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public enum InteractMessage implements CustomPacketPayload
{
    INSTANCE;

    public static final CustomPacketPayload.Type<InteractMessage> TYPE;
    public static final StreamCodec<ByteBuf, InteractMessage> STREAM_CODEC;

    public static void handler(IPayloadContext context) {
        InteractMessage.handleInteract(context.player());
    }

    public static void handleInteract(Player player) {
        DroneEntity drone;
        ItemStack stack = player.getMainHandItem();
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked") && !player.getCooldowns().isOnCooldown(stack.getItem()) && (drone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"))) != null) {
            Entity lookingEntity;
            Vec3 looking = Vec3.atLowerCornerOf((Vec3i)player.level().clip(new ClipContext(drone.getEyePosition(), drone.getEyePosition().add(drone.getLookAngle().scale(2.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).getBlockPos());
            BlockPos blockPos = BlockPos.containing((double)looking.x(), (double)looking.y(), (double)looking.z());
            ItemInteractionResult result = player.level().getBlockState(blockPos).useItemOn(player.getMainHandItem(), player.level(), player, InteractionHand.MAIN_HAND, BlockHitResult.miss((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (Direction)Direction.UP, (BlockPos)blockPos));
            if (result == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
                player.level().getBlockState(blockPos).useWithoutItem(player.level(), player, BlockHitResult.miss((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (Direction)Direction.UP, (BlockPos)blockPos));
            }
            if ((lookingEntity = TraceTool.findLookingEntity(drone, 2.0)) == null) {
                return;
            }
            player.attack(lookingEntity);
            player.getCooldowns().addCooldown(stack.getItem(), 13);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        TYPE = new CustomPacketPayload.Type(Mod.loc("interact"));
        STREAM_CODEC = StreamCodec.unit((Object)((Object)INSTANCE));
    }
}

