/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record LungeMineAttackMessage(int msgType, UUID uuid, Vec3 pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LungeMineAttackMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("lunge_mine_melee_attack"));
    public static final StreamCodec<ByteBuf, LungeMineAttackMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, LungeMineAttackMessage::msgType, (StreamCodec)UUIDUtil.STREAM_CODEC, LungeMineAttackMessage::uuid, (StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, Vec3::x, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::y, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::z, Vec3::new), LungeMineAttackMessage::pos, LungeMineAttackMessage::new);

    public static void handler(LungeMineAttackMessage message, IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getMainHandItem();
        if (stack.is((Item)ModItems.LUNGE_MINE.get())) {
            if (message.msgType == 0) {
                Entity lookingEntity;
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if ((lookingEntity = EntityFindUtil.findEntity(player.level(), String.valueOf(message.uuid))) != null) {
                    DamageHandler.doDamage(lookingEntity, ModDamageTypes.causeLungeMineDamage(player.level().registryAccess(), (Entity)player, (Entity)player), lookingEntity instanceof VehicleEntity ? 600.0f : 150.0f);
                    LungeMineAttackMessage.causeLungeMineExplode((Entity)player, lookingEntity);
                }
            } else if (message.msgType == 1) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                new CustomExplosion.Builder((Entity)player).damage(60.0f).radius(4.0f).damageMultiplier(1.25f).withParticleType(ParticleTool.ParticleType.MEDIUM).position(message.pos).explode();
            }
            player.swing(InteractionHand.MAIN_HAND);
        }
    }

    public static void causeLungeMineExplode(Entity attacker, Entity target) {
        new CustomExplosion.Builder(target).damage(60.0f).radius(4.0f).attacker(attacker).damageMultiplier(1.25f).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

