/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.menu.ChargingStationMenu;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ShowChargingRangeMessage(boolean operation) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShowChargingRangeMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("show_charging_range"));
    public static final StreamCodec<ByteBuf, ShowChargingRangeMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ShowChargingRangeMessage::operation, ShowChargingRangeMessage::new);

    public static void handler(ShowChargingRangeMessage message, IPayloadContext context) {
        Player player = context.player();
        AbstractContainerMenu menu = player.containerMenu;
        if (menu instanceof ChargingStationMenu) {
            ChargingStationMenu chargingStationMenu = (ChargingStationMenu)menu;
            if (!chargingStationMenu.stillValid(player)) {
                return;
            }
            chargingStationMenu.setShowRange(message.operation);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

