/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.init.ModPotions;
import java.util.Arrays;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="superbwarfare")
public class ModPotionRecipes {
    @SubscribeEvent
    public static void register(RegisterBrewingRecipesEvent event) {
        ItemStack water = ModPotionRecipes.potion((Holder<Potion>)Potions.WATER);
        ItemStack shock = ModPotionRecipes.potion(ModPotions.SHOCK);
        ItemStack strongShock = ModPotionRecipes.potion(ModPotions.STRONG_SHOCK);
        ItemStack longShock = ModPotionRecipes.potion(ModPotions.LONG_SHOCK);
        event.getBuilder().addRecipe(ModPotionRecipes.createRecipe(Ingredient.of((ItemStack[])new ItemStack[]{water}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHTNING_ROD}), shock));
        event.getBuilder().addRecipe(ModPotionRecipes.createRecipe(Ingredient.of((ItemStack[])new ItemStack[]{shock}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), strongShock));
        event.getBuilder().addRecipe(ModPotionRecipes.createRecipe(Ingredient.of((ItemStack[])new ItemStack[]{shock}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), longShock));
    }

    public static ItemStack potion(Holder<Potion> potion) {
        ItemStack stack = Items.POTION.getDefaultInstance();
        PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (contents != null) {
            stack.set(DataComponents.POTION_CONTENTS, (Object)contents.withPotion(potion));
        }
        return stack;
    }

    private static IBrewingRecipe createRecipe(final Ingredient input, final Ingredient ingredient, ItemStack output) {
        return new BrewingRecipe(input, ingredient, output){

            public boolean isInput(@NotNull ItemStack stack) {
                ItemStack[] matchingStacks = input.getItems();
                return matchingStacks.length == 0 ? stack.isEmpty() : Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack));
            }

            public boolean isIngredient(@NotNull ItemStack stack) {
                ItemStack[] matchingStacks = ingredient.getItems();
                return matchingStacks.length == 0 ? stack.isEmpty() : Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack));
            }
        };
    }
}

