/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.item.M18SmokeGrenade;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SmokeDyeRecipe
extends CustomRecipe {
    public SmokeDyeRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level pLevel) {
        ItemStack itemstack = ItemStack.EMPTY;
        ArrayList list = Lists.newArrayList();
        for (ItemStack stack : input.items()) {
            if (stack.isEmpty()) continue;
            if (stack.is((Item)ModItems.M18_SMOKE_GRENADE.get())) {
                if (!itemstack.isEmpty()) {
                    return false;
                }
                itemstack = stack;
                continue;
            }
            if (!(stack.getItem() instanceof DyeItem)) {
                return false;
            }
            list.add(stack);
        }
        return !itemstack.isEmpty() && !list.isEmpty();
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ArrayList list = Lists.newArrayList();
        ItemStack itemstack = ItemStack.EMPTY;
        for (ItemStack stack : input.items()) {
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (stack.is((Item)ModItems.M18_SMOKE_GRENADE.get())) {
                if (!itemstack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                itemstack = stack.copy();
                continue;
            }
            if (!(item instanceof DyeItem)) {
                return ItemStack.EMPTY;
            }
            DyeItem dyeItem = (DyeItem)item;
            list.add(dyeItem);
        }
        return !itemstack.isEmpty() && !list.isEmpty() ? SmokeDyeRecipe.dyeItem(itemstack, list) : ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SMOKE_DYE_SERIALIZER.get();
    }

    public static ItemStack dyeItem(ItemStack pStack, List<DyeItem> pDyes) {
        ItemStack itemstack;
        M18SmokeGrenade grenade;
        int[] colors = new int[3];
        int i = 0;
        int j = 0;
        Item item = pStack.getItem();
        if (item instanceof M18SmokeGrenade) {
            grenade = (M18SmokeGrenade)item;
            itemstack = pStack.copyWithCount(1);
            int color = grenade.getColor(pStack);
            if (color != 0xFFFFFF) {
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                i += (int)(Math.max(r, Math.max(g, b)) * 255.0f);
                colors[0] = colors[0] + (int)(r * 255.0f);
                colors[1] = colors[1] + (int)(g * 255.0f);
                colors[2] = colors[2] + (int)(b * 255.0f);
                ++j;
            }
            for (DyeItem dyeitem : pDyes) {
                int dyeColors = dyeitem.getDyeColor().getTextureDiffuseColor();
                int r = FastColor.ARGB32.red((int)dyeColors);
                int g = FastColor.ARGB32.green((int)dyeColors);
                int b = FastColor.ARGB32.blue((int)dyeColors);
                i += Math.max(r, Math.max(g, b));
                colors[0] = colors[0] + r;
                colors[1] = colors[1] + g;
                colors[2] = colors[2] + b;
                ++j;
            }
        } else {
            return ItemStack.EMPTY;
        }
        int red = colors[0] / j;
        int green = colors[1] / j;
        int blue = colors[2] / j;
        float rate = (float)i / (float)j;
        float max = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * rate / max);
        green = (int)((float)green * rate / max);
        blue = (int)((float)blue * rate / max);
        int color = (red << 8) + green;
        color = (color << 8) + blue;
        grenade.setColor(itemstack, color);
        return itemstack;
    }
}

