/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.resource;

import com.atsuishio.superbwarfare.data.ObjectToList;
import com.google.gson.annotations.SerializedName;
import net.minecraft.resources.ResourceLocation;

public class ModelResource {
    @SerializedName(value="Animation")
    public ResourceLocation animation;
    @SerializedName(value="Model")
    public ResourceLocation model;
    @SerializedName(value="LODModel")
    protected ObjectToList<ResourceLocation> lodModel = new ObjectToList<ResourceLocation>(new ResourceLocation[0]);
    @SerializedName(value="Texture")
    public ResourceLocation texture;
    @SerializedName(value="LODTexture")
    protected ObjectToList<ResourceLocation> lodTexture;

    public boolean hasLOD() {
        return this.lodModel != null && !this.lodModel.list.isEmpty();
    }

    public ResourceLocation getLODModel(int level) {
        if (level < 1 || this.lodModel == null || this.lodModel.list.isEmpty()) {
            return this.model;
        }
        int availableLevel = Math.min(level - 1, this.lodModel.list.size() - 1);
        return (ResourceLocation)this.lodModel.list.get(availableLevel);
    }

    public ResourceLocation getLODTexture(int level) {
        if (level < 1 || this.lodTexture == null || this.lodTexture.list.isEmpty()) {
            return this.texture;
        }
        int availableLevel = Math.min(level - 1, this.lodTexture.list.size() - 1);
        return (ResourceLocation)this.lodTexture.list.get(availableLevel);
    }
}

