/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.entity.mixin.DamageAccess;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.tools.FormatTool;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.damagesource.DamageContainer;

public class DamageHandler {
    public static boolean doDamage(Entity entity, DamageSource source, float damage) {
        if (entity.hurt(source, damage)) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity living = (LivingEntity)entity;
            if (!((Boolean)MiscConfig.ALLOW_FORCE_DAMAGE.get()).booleanValue()) {
                return false;
            }
            if (living.isInvulnerableTo(source)) {
                return false;
            }
            if (living.level().isClientSide) {
                return false;
            }
            if (living.isDeadOrDying()) {
                return false;
            }
            if (source.is(DamageTypeTags.IS_FIRE) && living.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                return false;
            }
            if (living instanceof Player && ((player = (Player)living).isCreative() || player.isSpectator())) {
                return false;
            }
            DamageAccess damageAccess = DamageAccess.of(living);
            damageAccess.superbwarfare$getDamageContainers().push(new DamageContainer(source, damage));
            if (CommonHooks.onEntityIncomingDamage((LivingEntity)living, (DamageContainer)damageAccess.superbwarfare$getDamageContainers().peek())) {
                return false;
            }
            if (living.isSleeping() && !living.level().isClientSide) {
                living.stopSleeping();
            }
            living.setNoActionTime(0);
            float f = damage = damageAccess.superbwarfare$getDamageContainers().peek().getNewDamage();
            boolean flag = false;
            if (source.is(DamageTypeTags.IS_FREEZING) && living.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
                damage *= 5.0f;
            }
            if (source.is(DamageTypeTags.DAMAGES_HELMET) && !living.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                damageAccess.superbWarfare$hurtHelmet(source, damage);
                damage *= 0.75f;
            }
            damageAccess.superbwarfare$getDamageContainers().peek().setNewDamage(damage);
            living.walkAnimation.setSpeed(1.5f);
            boolean flag1 = true;
            if ((float)living.invulnerableTime > 10.0f && !source.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
                if (damage <= living.lastHurt) {
                    damageAccess.superbwarfare$getDamageContainers().pop();
                    return false;
                }
                damageAccess.superbWarfare$actuallyHurt(source, damage - living.lastHurt);
                living.lastHurt = damage;
                flag1 = false;
            } else {
                living.lastHurt = damage;
                living.invulnerableTime = damageAccess.superbwarfare$getDamageContainers().peek().getPostAttackInvulnerabilityTicks();
                damageAccess.superbWarfare$actuallyHurt(source, damage);
                living.hurtTime = living.hurtDuration = 10;
            }
            damage = damageAccess.superbwarfare$getDamageContainers().peek().getNewDamage();
            entity = source.getEntity();
            if (entity != null) {
                TamableAnimal tamableAnimal;
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity1 = (LivingEntity)entity;
                    if (!(source.is(DamageTypeTags.NO_ANGER) || source.is(DamageTypes.WIND_CHARGE) && living.getType().is(EntityTypeTags.NO_ANGER_FROM_WIND_CHARGE))) {
                        living.setLastHurtByMob(livingentity1);
                    }
                }
                if (entity instanceof Player) {
                    Player player1 = (Player)entity;
                    living.lastHurtByPlayerTime = 100;
                    living.setLastHurtByPlayer(player1);
                } else if (entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).isTame()) {
                    living.lastHurtByPlayerTime = 100;
                    LivingEntity var12 = tamableAnimal.getOwner();
                    if (var12 instanceof Player) {
                        living.setLastHurtByPlayer((Player)var12);
                    } else {
                        living.setLastHurtByPlayer(null);
                    }
                }
            }
            if (flag1) {
                living.level().broadcastDamageEvent((Entity)living, source);
                if (!source.is(DamageTypeTags.NO_IMPACT)) {
                    living.hurtMarked = true;
                }
                if (!source.is(DamageTypeTags.NO_KNOCKBACK)) {
                    double d0 = 0.0;
                    double d1 = 0.0;
                    Entity var14 = source.getDirectEntity();
                    if (var14 instanceof Projectile) {
                        Projectile projectile = (Projectile)var14;
                        DoubleDoubleImmutablePair doubledoubleimmutablepair = projectile.calculateHorizontalHurtKnockbackDirection(living, source);
                        d0 = -doubledoubleimmutablepair.leftDouble();
                        d1 = -doubledoubleimmutablepair.rightDouble();
                    } else if (source.getSourcePosition() != null) {
                        d0 = source.getSourcePosition().x() - living.getX();
                        d1 = source.getSourcePosition().z() - living.getZ();
                    }
                    living.knockback((double)0.4f, d0, d1);
                    if (!flag) {
                        living.indicateDamage(d0, d1);
                    }
                }
            }
            if (living.isDeadOrDying()) {
                if (!damageAccess.superbWarfare$checkTotemDeathProtection(source)) {
                    if (flag1) {
                        living.makeSound(damageAccess.superbWarfare$getDeathSound());
                    }
                    living.die(source);
                }
            } else if (flag1) {
                damageAccess.superbWarfare$playHurtSound(source);
            }
            living.lastDamageSource = source;
            living.lastDamageStamp = living.level().getGameTime();
            for (MobEffectInstance mobeffectinstance : living.getActiveEffects()) {
                mobeffectinstance.onMobHurt(living, source, damage);
            }
            if (living instanceof ServerPlayer) {
                CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((ServerPlayer)living, source, f, damage, flag);
            }
            if (entity instanceof ServerPlayer) {
                CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((ServerPlayer)entity, (Entity)living, source, f, damage, flag);
            }
            damageAccess.superbwarfare$getDamageContainers().pop();
            return true;
        }
        return false;
    }

    public static MutableComponent getDamageInfo(VehicleEntity vehicle, DamageSource source, float damage) {
        List<DamageModifier.ModifyResult> detailedDamageResult = vehicle.getDamageModifier().matchResult(source, damage);
        float finalDamage = detailedDamageResult.isEmpty() ? damage : detailedDamageResult.getLast().damage();
        MutableComponent details = Component.empty().append((Component)Component.translatable((String)"des.superbwarfare.vehicle_damage_analyzer.info.raw", (Object[])new Object[]{FormatTool.format2D(damage) + "\n"}).withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.UNDERLINE)).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)DamageHandler.integrateInfo(detailedDamageResult)).append((Component)Component.translatable((String)"des.superbwarfare.vehicle_damage_analyzer.info.final", (Object[])new Object[]{FormatTool.format2D(finalDamage)}).withStyle(ChatFormatting.GREEN));
        return Component.literal((String)"[").append(vehicle.getDisplayName()).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.WHITE)).append((Component)Component.translatable((String)"des.superbwarfare.vehicle_damage_analyzer.info.raw", (Object[])new Object[]{FormatTool.format2D(damage)}).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" => ").withStyle(ChatFormatting.WHITE)).append((Component)Component.translatable((String)"des.superbwarfare.vehicle_damage_analyzer.info.final", (Object[])new Object[]{FormatTool.format2D(finalDamage)}).withStyle(ChatFormatting.GREEN)).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)details)));
    }

    private static MutableComponent integrateInfo(List<DamageModifier.ModifyResult> results) {
        MutableComponent info = Component.empty();
        for (DamageModifier.ModifyResult result : results) {
            info = info.append((Component)result.getDamageInfo()).append((Component)Component.literal((String)"\n").withStyle(ChatFormatting.RESET));
        }
        return info;
    }
}

