/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;

public class EntityFindUtil {
    public static LevelEntityGetter<Entity> getEntities(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getEntities();
        }
        ClientLevel clientLevel = (ClientLevel)level;
        return clientLevel.getEntities();
    }

    public static Entity findEntity(Level level, String uuidString) {
        try {
            Entity target;
            UUID uuid = UUID.fromString(uuidString);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                target = serverLevel.getEntity(uuid);
            } else {
                ClientLevel clientLevel = (ClientLevel)level;
                target = (Entity)clientLevel.getEntities().get(uuid);
            }
            return target;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Player findPlayer(Level level, String uuidString) {
        Entity target = EntityFindUtil.findEntity(level, uuidString);
        if (target instanceof Player) {
            Player player = (Player)target;
            return player;
        }
        return null;
    }

    public static DroneEntity findDrone(Level level, String uuidString) {
        Entity target = EntityFindUtil.findEntity(level, uuidString);
        if (target instanceof DroneEntity) {
            DroneEntity drone = (DroneEntity)target;
            return drone;
        }
        return null;
    }
}

