/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.joml.Vector4d;

@EventBusSubscriber(value={Dist.CLIENT})
public class VectorUtil {
    public static double fov = 70.0;
    public static Matrix4f modelViewMatrix;
    public static Matrix4f projectionMatrix;

    public static Vec3 worldToScreen(Vec3 pos) {
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vector4d worldPosRel = new Vector4d((Vector3fc)camera.getPosition().reverse().add(pos).toVector3f(), 1.0);
        worldPosRel.mul((Matrix4fc)modelViewMatrix);
        worldPosRel.mul((Matrix4fc)projectionMatrix);
        double depth = worldPosRel.w;
        if (depth != 0.0) {
            worldPosRel.div(depth);
        }
        return new Vec3((double)window.getGuiScaledWidth() * (0.5 + worldPosRel.x * 0.5), (double)window.getGuiScaledHeight() * (0.5 - worldPosRel.y * 0.5), depth);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void captureFov(ViewportEvent.ComputeFov event) {
        if (event.usedConfiguredFov()) {
            fov = event.getFOV();
        }
    }

    public static boolean canSee(Vec3 pos) {
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        Vec3 viewVec = new Vec3(camera.getLookVector());
        Vec3 v1 = cameraPos.vectorTo(pos);
        return VectorTool.calculateAngle(v1, viewVec) < fov + 10.0;
    }
}

