package com.atsuishio.superbwarfare.tools;

import net.minecraft.world.item.ItemStack;

// From Botania
public final class ItemNBTTool {
    public static boolean verifyExistence(ItemStack stack, String tag) {
        return !stack.isEmpty() && stack.getOrCreateTag().contains(tag);
    }

    public static void setBoolean(ItemStack stack, String tag, boolean b) {
        stack.getOrCreateTag().putBoolean(tag, b);
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultExpected) {
        return verifyExistence(stack, tag) ? stack.getOrCreateTag().getBoolean(tag) : defaultExpected;
    }

    public static void setFloat(ItemStack stack, String tag, float f) {
        stack.getOrCreateTag().putFloat(tag, f);
    }

    public static float getFloat(ItemStack stack, String tag, float f) {
        return verifyExistence(stack, tag) ? stack.getOrCreateTag().getFloat(tag) : f;
    }

    public static void setInt(ItemStack stack, String tag, int num) {
        stack.getOrCreateTag().putInt(tag, num);
    }

    public static int getInt(ItemStack stack, String tag, int num) {
        return verifyExistence(stack, tag) ? stack.getOrCreateTag().getInt(tag) : num;
    }

    public static void setLong(ItemStack stack, String tag, long num) {
        stack.getOrCreateTag().putLong(tag, num);
    }

    public static long getLong(ItemStack stack, String tag, long num) {
        return verifyExistence(stack, tag) ? stack.getOrCreateTag().getLong(tag) : num;
    }

    public static void setDouble(ItemStack stack, String tag, double num) {
        stack.getOrCreateTag().putDouble(tag, num);
    }

    public static double getDouble(ItemStack stack, String tag, double num) {
        return verifyExistence(stack, tag) ? stack.getOrCreateTag().getDouble(tag) : num;
    }
}