/*
 * Decompiled with CFR 0.152.
 */
package net.mcbrawls.inject.api;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import net.mcbrawls.inject.api.InjectorContext;
import net.mcbrawls.inject.api.PacketDirection;

@ChannelHandler.Sharable
public abstract class Injector
extends ChannelDuplexHandler {
    public boolean isRelevant(InjectorContext ctx, PacketDirection direction) {
        return false;
    }

    public boolean onRead(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        return false;
    }

    public boolean onWrite(ChannelHandlerContext ctx, ByteBuf buf, ChannelPromise promise) {
        return false;
    }

    private ByteBuf extractByteBuf(Object msg) {
        ByteBuf buf = null;
        if (msg instanceof ByteBuf) {
            ByteBuf byteBuf;
            buf = byteBuf = (ByteBuf)msg;
        }
        return buf;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = this.extractByteBuf(msg);
        if (buf == null) {
            return;
        }
        InjectorContext context = new InjectorContext(ctx.pipeline(), buf);
        if (!this.isRelevant(context, PacketDirection.INBOUND)) {
            super.channelRead(ctx, msg);
            return;
        }
        if (!this.onRead(ctx, buf)) {
            super.channelRead(ctx, msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf buf = this.extractByteBuf(msg);
        if (buf == null) {
            return;
        }
        InjectorContext context = new InjectorContext(ctx.pipeline(), buf);
        if (!this.isRelevant(context, PacketDirection.OUTBOUND)) {
            super.write(ctx, msg, promise);
            return;
        }
        if (!this.onWrite(ctx, buf, promise)) {
            super.write(ctx, msg, promise);
        }
    }
}

