/*
 * Decompiled with CFR 0.152.
 */
package com.jules.quickstack.network;

import com.jules.quickstack.Config;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record QuickStackPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<QuickStackPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"quickstack", (String)"quick_stack"));
    public static final StreamCodec<ByteBuf, QuickStackPacket> STREAM_CODEC = StreamCodec.unit((Object)new QuickStackPacket());
    private static Method ipnIsSlotLockedMethod;
    private static Object ipnLockSlotsHandlerInstance;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        try {
            Class<?> lockSlotsHandlerClass = Class.forName("org.anti_ad.mc.ipnext.event.LockSlotsHandler");
            ipnLockSlotsHandlerInstance = lockSlotsHandlerClass.getField("INSTANCE").get(null);
            ipnIsSlotLockedMethod = lockSlotsHandlerClass.getMethod("isSlotLocked", Integer.TYPE);
        }
        catch (Exception e) {
            ipnIsSlotLockedMethod = null;
            ipnLockSlotsHandlerInstance = null;
        }
    }

    public static class Handler {
        public static void handle(QuickStackPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player player = context.player();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Level world = serverPlayer.level();
                    BlockPos playerPos = serverPlayer.blockPosition();
                    ArrayList nearbyInventories = new ArrayList();
                    int range = (Integer)Config.QUICK_STACK_RANGE.get();
                    int chunkRange = range >> 4;
                    for (int chunkX = (playerPos.getX() >> 4) - chunkRange; chunkX <= (playerPos.getX() >> 4) + chunkRange; ++chunkX) {
                        for (int chunkZ = (playerPos.getZ() >> 4) - chunkRange; chunkZ <= (playerPos.getZ() >> 4) + chunkRange; ++chunkZ) {
                            LevelChunk chunk = world.getChunk(chunkX, chunkZ);
                            chunk.getBlockEntities().values().forEach(be -> {
                                IItemHandler handler;
                                if (playerPos.distSqr((Vec3i)be.getBlockPos()) <= (double)(range * range) && (handler = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), null)) != null) {
                                    nearbyInventories.add(handler);
                                }
                            });
                        }
                    }
                    if (nearbyInventories.isEmpty()) {
                        return;
                    }
                    block4: for (int i = 0; i < serverPlayer.getInventory().getContainerSize(); ++i) {
                        ItemStack playerStack = serverPlayer.getInventory().getItem(i);
                        if (playerStack.isEmpty()) continue;
                        boolean isIpnLocked = false;
                        if (ipnIsSlotLockedMethod != null) {
                            try {
                                isIpnLocked = (Boolean)ipnIsSlotLockedMethod.invoke(ipnLockSlotsHandlerInstance, i);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (isIpnLocked) continue;
                        CompoundTag customData = ((CustomData)playerStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                        boolean isPinned = false;
                        for (String tag : (List)Config.PINNED_SLOT_TAGS.get()) {
                            if (!customData.getBoolean(tag)) continue;
                            isPinned = true;
                            break;
                        }
                        if (isPinned) continue;
                        for (IItemHandler inventory : nearbyInventories) {
                            boolean itemExists = false;
                            for (int j = 0; j < inventory.getSlots(); ++j) {
                                if (!ItemStack.isSameItemSameComponents((ItemStack)playerStack, (ItemStack)inventory.getStackInSlot(j))) continue;
                                itemExists = true;
                                break;
                            }
                            if (!itemExists) continue;
                            ItemStack remainingStack = ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)playerStack, (boolean)false);
                            serverPlayer.getInventory().setItem(i, remainingStack);
                            if (!remainingStack.isEmpty()) continue;
                            continue block4;
                        }
                    }
                }
            });
        }
    }
}

