/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.herenthere;

import dev.terminalmc.herenthere.config.Alias;
import dev.terminalmc.herenthere.config.Config;
import dev.terminalmc.herenthere.placeholder.Placeholders;
import dev.terminalmc.herenthere.util.ModLogger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class HereNThere {
    public static final String MOD_ID = "herenthere";
    public static final String MOD_NAME = "HereNThere";
    public static final ModLogger LOG = new ModLogger("HereNThere");
    public static final Component PREFIX = Component.empty().append((Component)Component.literal((String)"[").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"HereNThere").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"] ").withStyle(ChatFormatting.DARK_GRAY)).withStyle(ChatFormatting.GRAY);
    public static final List<KeyMapping> KEYBINDS = List.of();
    public static final List<Alias> ALIASES = new ArrayList<Alias>();

    public static void init() {
        Config.getAndSave();
    }

    public static void afterClientTick(Minecraft mc) {
    }

    public static void onConfigSaved(Config config) {
        ALIASES.clear();
        ALIASES.addAll(Config.options().aliases);
        ALIASES.sort(Comparator.comparingInt(a -> -a.alias.length()));
    }

    @Nullable
    public static String onTabKey(String before, String after) {
        if (!Config.options().modEnabled) {
            return null;
        }
        if (Minecraft.getInstance().player == null) {
            return null;
        }
        if (Minecraft.getInstance().level == null) {
            return null;
        }
        for (Alias alias : ALIASES) {
            if (!HereNThere.aliasMatches(alias.alias, before)) continue;
            Placeholders.PlaceholderResult result = Placeholders.replace(alias.replacement);
            return before.substring(0, before.length() - alias.alias.length()) + result.string() + after;
        }
        return null;
    }

    private static boolean aliasMatches(String alias, String before) {
        if (Config.options().requireDelimiter) {
            return Pattern.compile("(?<!\\w)" + Pattern.quote(alias) + "$").matcher(before).find();
        }
        return before.endsWith(alias);
    }
}

