/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.herenthere.gui.screen;

import dev.terminalmc.herenthere.HereNThere;
import dev.terminalmc.herenthere.config.Alias;
import dev.terminalmc.herenthere.config.Config;
import dev.terminalmc.herenthere.util.Localization;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClothScreenProvider {
    static Screen getConfigScreen(Screen parent) {
        Config.Options options = Config.options();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Localization.localized("name", new Object[0])).setSavingRunnable(Config::save);
        ConfigEntryBuilder eb = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((Component)Localization.localized("option", "general", new Object[0]));
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Localization.localized("option", "general.modEnabled", new Object[0]), options.modEnabled).setDefaultValue(true).setSaveConsumer(val -> {
            options.modEnabled = val;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Localization.localized("option", "general.requireDelimiter", new Object[0]), options.requireDelimiter).setTooltip(new Component[]{Localization.localized("option", "general.requireDelimiter.tooltip", new Object[0])}).setDefaultValue(true).setSaveConsumer(val -> {
            options.requireDelimiter = val;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startStrList((Component)Localization.localized("option", "aliases", new Object[0]), ClothScreenProvider.getLayoutStrings(options.aliases)).setTooltip(new Component[]{Localization.localized("option", "aliases.tooltip.1", new Object[0]).append("\n").append((Component)Localization.localized("option", "aliases.tooltip.2", new Object[0])).append("\n").append((Component)Localization.localized("option", "aliases.tooltip.3", new Object[0]))}).setExpanded(true).setInsertInFront(true).setErrorSupplier(list -> {
            int i = 0;
            for (String string : list) {
                try {
                    Alias.fromDataString(string);
                }
                catch (ParseException ex) {
                    return Optional.of(Localization.localized("error", "alias.parse", i + 1, ex.getMessage()));
                }
                ++i;
            }
            return Optional.empty();
        }).setDefaultValue(ClothScreenProvider.getLayoutStrings((Collection<Alias>)Config.Options.aliasesDefault.get())).setSaveConsumer(list -> {
            HashSet<Alias> aliases = new HashSet<Alias>();
            for (String string : list) {
                try {
                    Alias alias = Alias.fromDataString(string);
                    aliases.add(alias);
                }
                catch (ParseException ex) {
                    HereNThere.LOG.error("Encountered an alias parsing error not caught by error checker: {}", ex.getMessage());
                    break;
                }
            }
            options.aliases.clear();
            options.aliases.addAll(aliases);
        }).build());
        return builder.build();
    }

    private static List<String> getLayoutStrings(Collection<Alias> aliases) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Alias alias : aliases) {
            strings.add(alias.toDataString());
        }
        return strings;
    }
}

