/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.herenthere.placeholder.util;

import dev.terminalmc.herenthere.placeholder.Placeholders;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerPositionUtil {
    @Nullable
    private static Vec3 playerPos;
    @Nullable
    private static BlockPos playerBlockPos;
    @Nullable
    private static BlockPos lookBlockPos;
    @Nullable
    private static Vec3 lookAngle;
    @Nullable
    private static Vec2 rotation;

    public static void reset() {
        playerPos = null;
        playerBlockPos = null;
        lookBlockPos = null;
        lookAngle = null;
        rotation = null;
    }

    @NotNull
    private static Vec3 getPlayerPos() {
        if (playerPos == null) {
            playerPos = Minecraft.getInstance().player.position();
        }
        return playerPos;
    }

    @NotNull
    private static BlockPos getPlayerBlockPos() {
        if (playerBlockPos == null) {
            playerBlockPos = Minecraft.getInstance().player.blockPosition();
        }
        return playerBlockPos;
    }

    @Nullable
    private static BlockPos getLookBlockPos() {
        if (lookBlockPos == null) {
            Minecraft mc = Minecraft.getInstance();
            HitResult result = mc.player.pick(Math.max(384.0, (mc.levelRenderer.getLastViewDistance() + 1.0) * 16.0), 0.0f, false);
            if (result.getType().equals((Object)HitResult.Type.BLOCK)) {
                lookBlockPos = ((BlockHitResult)result).getBlockPos();
            }
        }
        return lookBlockPos;
    }

    @NotNull
    private static Vec3 getLookAngle() {
        if (lookAngle == null) {
            lookAngle = Minecraft.getInstance().player.getLookAngle();
        }
        return lookAngle;
    }

    @NotNull
    private static Vec2 getRotation() {
        if (rotation == null) {
            rotation = Minecraft.getInstance().player.getRotationVector();
        }
        return rotation;
    }

    public static String getPosString(String[] groups) {
        Vec3 pos;
        double forwardsCaret;
        if (groups.length != 6) {
            return Placeholders.fault();
        }
        boolean look = groups[0].equals("l");
        boolean decimal = groups[1].equals("d");
        String delimiter = groups[2];
        double leftCaret = groups[3] == null ? 0.0 : Double.parseDouble(groups[3]);
        double upCaret = groups[4] == null ? 0.0 : Double.parseDouble(groups[4]);
        double d = forwardsCaret = groups[5] == null ? 0.0 : Double.parseDouble(groups[5]);
        if (look) {
            BlockPos lookPos = PlayerPositionUtil.getLookBlockPos();
            Vec3 vec3 = pos = lookPos == null ? null : lookPos.getBottomCenter();
            if (pos == null) {
                return Placeholders.fault();
            }
        } else {
            pos = decimal ? PlayerPositionUtil.getPlayerPos() : PlayerPositionUtil.getPlayerBlockPos().getBottomCenter();
        }
        pos = PlayerPositionUtil.applyCaret(pos, leftCaret, upCaret, forwardsCaret);
        if (decimal) {
            return String.format("%f%s%f%s%f", pos.x, delimiter, pos.y, delimiter, pos.z);
        }
        return String.format("%d%s%d%s%d", Mth.floor((double)pos.x), delimiter, Mth.floor((double)pos.y), delimiter, Mth.floor((double)pos.z));
    }

    private static Vec3 applyCaret(Vec3 pos, double left, double up, double forwards) {
        Vec2 rot = PlayerPositionUtil.getRotation();
        float f = Mth.cos((float)((rot.y + 90.0f) * ((float)Math.PI / 180)));
        float g = Mth.sin((float)((rot.y + 90.0f) * ((float)Math.PI / 180)));
        float h = Mth.cos((float)(-rot.x * ((float)Math.PI / 180)));
        float i = Mth.sin((float)(-rot.x * ((float)Math.PI / 180)));
        float j = Mth.cos((float)((-rot.x + 90.0f) * ((float)Math.PI / 180)));
        float k = Mth.sin((float)((-rot.x + 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec32 = new Vec3((double)(f * h), (double)i, (double)(g * h));
        Vec3 vec33 = new Vec3((double)(f * j), (double)k, (double)(g * j));
        Vec3 vec34 = vec32.cross(vec33).scale(-1.0);
        double d = vec32.x * forwards + vec33.x * up + vec34.x * left;
        double e = vec32.y * forwards + vec33.y * up + vec34.y * left;
        double l = vec32.z * forwards + vec33.z * up + vec34.z * left;
        return new Vec3(pos.x + d, pos.y + e, pos.z + l);
    }

    public static String getPosComponentString(String[] groups) {
        Vec3 pos;
        double operand;
        if (groups.length != 5) {
            return Placeholders.fault();
        }
        boolean look = groups[0].equals("l");
        String component = groups[1];
        boolean decimal = groups[2].equals("d");
        String operator = groups[3];
        double d = operand = groups[4] == null ? 0.0 : Double.parseDouble(groups[4]);
        if (look) {
            BlockPos lookPos = PlayerPositionUtil.getLookBlockPos();
            Vec3 vec3 = pos = lookPos == null ? null : lookPos.getBottomCenter();
            if (pos == null) {
                return Placeholders.fault();
            }
        } else {
            pos = decimal ? PlayerPositionUtil.getPlayerPos() : PlayerPositionUtil.getPlayerBlockPos().getBottomCenter();
        }
        double value = switch (component) {
            case "x" -> pos.x;
            case "y" -> pos.y;
            case "z" -> pos.z;
            default -> throw new IllegalArgumentException();
        };
        if (operator != null) {
            value = switch (operator) {
                case "+" -> value + operand;
                case "-" -> value - operand;
                case "*" -> value * operand;
                case "/" -> value / operand;
                default -> throw new IllegalArgumentException();
            };
        }
        if (decimal) {
            return String.format("%f", value);
        }
        return String.format("%d", Mth.floor((double)value));
    }

    public static String getFacingAngleString(String[] groups) {
        if (groups.length != 3) {
            return Placeholders.fault();
        }
        String delimiter = groups[0];
        @Nullable String operator = groups[1];
        double operand = groups[2] == null ? 0.0 : Double.parseDouble(groups[2]);
        Vec3 vec = PlayerPositionUtil.getLookAngle();
        if (operator != null) {
            vec = switch (operator) {
                case "+" -> vec.add(vec.scale(operand));
                case "-" -> vec.subtract(vec.scale(operand));
                case "*" -> vec.scale(operand);
                case "/" -> vec.scale(1.0 / operand);
                default -> throw new IllegalArgumentException();
            };
        }
        return String.format("%f%s%f%s%f", vec.x, delimiter, vec.y, delimiter, vec.z);
    }
}

