/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.energy;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.ISidedStrictEnergyHandler;
import mekanism.api.math.LongTransferUtils;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IMekanismStrictEnergyHandler
extends ISidedStrictEnergyHandler,
IContentsListener {
    default public boolean canHandleEnergy() {
        return true;
    }

    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction var1);

    @Nullable
    default public IEnergyContainer getEnergyContainer(int container, @Nullable Direction side) {
        List<IEnergyContainer> containers = this.getEnergyContainers(side);
        return container >= 0 && container < containers.size() ? containers.get(container) : null;
    }

    @Override
    default public int getEnergyContainerCount(@Nullable Direction side) {
        return this.getEnergyContainers(side).size();
    }

    @Override
    default public long getEnergy(int container, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? 0L : energyContainer.getEnergy();
    }

    @Override
    default public void setEnergy(int container, long energy, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        if (energyContainer != null) {
            energyContainer.setEnergy(Math.max(0L, energy));
        }
    }

    @Override
    default public long getMaxEnergy(int container, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? 0L : energyContainer.getMaxEnergy();
    }

    @Override
    default public long getNeededEnergy(int container, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? 0L : energyContainer.getNeeded();
    }

    @Override
    default public long insertEnergy(int container, long amount, @Nullable Direction side, Action action) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? amount : energyContainer.insert(amount, action, AutomationType.handler(side));
    }

    @Override
    default public long extractEnergy(int container, long amount, @Nullable Direction side, Action action) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? 0L : energyContainer.extract(amount, action, AutomationType.handler(side));
    }

    @Override
    default public long insertEnergy(long amount, @Nullable Direction side, Action action) {
        return LongTransferUtils.insert(amount, side, this::getEnergyContainers, action, AutomationType.handler(side));
    }

    @Override
    default public long extractEnergy(long amount, @Nullable Direction side, Action action) {
        return LongTransferUtils.extract(amount, side, this::getEnergyContainers, action, AutomationType.handler(side));
    }
}

