/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.inventory;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.ISidedItemHandler;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IMekanismInventory
extends ISidedItemHandler,
IContentsListener {
    default public boolean hasInventory() {
        return true;
    }

    public List<IInventorySlot> getInventorySlots(@Nullable Direction var1);

    @Nullable
    default public IInventorySlot getInventorySlot(int slot, @Nullable Direction side) {
        List<IInventorySlot> slots = this.getInventorySlots(side);
        return slot >= 0 && slot < slots.size() ? slots.get(slot) : null;
    }

    @Override
    default public void setStackInSlot(int slot, ItemStack stack, @Nullable Direction side) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        if (inventorySlot != null) {
            inventorySlot.setStack(stack);
        }
    }

    @Override
    default public int getSlots(@Nullable Direction side) {
        return this.getInventorySlots(side).size();
    }

    @Override
    default public ItemStack getStackInSlot(int slot, @Nullable Direction side) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        return inventorySlot == null ? ItemStack.EMPTY : inventorySlot.getStack();
    }

    @Override
    default public ItemStack insertItem(int slot, ItemStack stack, @Nullable Direction side, Action action) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        if (inventorySlot == null) {
            return stack;
        }
        return inventorySlot.insertItem(stack, action, AutomationType.handler(side));
    }

    @Override
    default public ItemStack extractItem(int slot, int amount, @Nullable Direction side, Action action) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        if (inventorySlot == null) {
            return ItemStack.EMPTY;
        }
        return inventorySlot.extractItem(amount, action, AutomationType.handler(side));
    }

    @Override
    default public int getSlotLimit(int slot, @Nullable Direction side) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        return inventorySlot == null ? 0 : inventorySlot.getLimit(ItemStack.EMPTY);
    }

    @Override
    default public boolean isItemValid(int slot, ItemStack stack, @Nullable Direction side) {
        IInventorySlot inventorySlot = this.getInventorySlot(slot, side);
        return inventorySlot != null && inventorySlot.isItemValid(stack);
    }

    default public boolean isInventoryEmpty(@Nullable Direction side) {
        for (IInventorySlot slot : this.getInventorySlots(side)) {
            if (slot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public boolean isInventoryEmpty() {
        return this.isInventoryEmpty(this.getInventorySideFor());
    }
}

