/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.MekanismAPITags;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.datamaps.chemical.ChemicalSolidTag;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.common.MekanismLang;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiQIOCrystallizerScreen
extends GuiInnerScreen {
    @Nullable
    private final GuiSequencedSlotDisplay slotDisplay;
    private final List<ItemStack> iterStacks;
    private final IOreInfo oreInfo;
    private final GuiSlot slot;
    @NotNull
    private Holder<Chemical> prevSlurry = MekanismAPI.EMPTY_CHEMICAL_HOLDER;

    public GuiQIOCrystallizerScreen(IGuiWrapper gui, int x, int y, int width, int height, IOreInfo oreInfo) {
        super(gui, x, y, width, height);
        this.oreInfo = oreInfo;
        int slotX = this.relativeX + this.width - SlotType.ORE.getWidth();
        this.slot = this.addChild(new GuiSlot(SlotType.ORE, gui, slotX, this.relativeY));
        if (this.oreInfo.usesSequencedDisplay()) {
            this.iterStacks = new ArrayList<ItemStack>();
            this.slotDisplay = this.addChild(new GuiSequencedSlotDisplay(gui, slotX + 1, this.relativeY + 1, () -> this.iterStacks));
            this.updateSlotContents();
        } else {
            this.iterStacks = Collections.emptyList();
            this.slotDisplay = null;
        }
        this.defaultFormat();
    }

    public int getSlotX() {
        return this.slot.getX();
    }

    public int getSlotY() {
        return this.slot.getY();
    }

    @Override
    public void tick() {
        this.updateSlotContents();
        super.tick();
    }

    private void updateSlotContents() {
        if (this.oreInfo.usesSequencedDisplay() && this.slotDisplay != null) {
            ChemicalStack chemical = this.oreInfo.getInputChemical();
            if (!chemical.isEmpty()) {
                if (!chemical.is(this.prevSlurry)) {
                    this.prevSlurry = chemical.getChemicalHolder();
                    this.iterStacks.clear();
                    if (!this.prevSlurry.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                        TagKey<Item> oreTag;
                        ChemicalSolidTag tag = chemical.getData(IMekanismDataMapTypes.INSTANCE.chemicalSolidTag());
                        if (tag != null) {
                            HolderSet.Named tagContents = tag.lookupTag().orElse(null);
                            if (tagContents != null) {
                                for (Holder tagContent : tagContents) {
                                    this.iterStacks.add(new ItemStack(tagContent));
                                }
                            }
                        } else if (!this.prevSlurry.is(MekanismAPITags.Chemicals.DIRTY) && (oreTag = ((Chemical)this.prevSlurry.value()).getOreTag()) != null) {
                            for (Holder ore : BuiltInRegistries.ITEM.getTagOrEmpty(oreTag)) {
                                this.iterStacks.add(new ItemStack(ore));
                            }
                        }
                    }
                    this.slotDisplay.updateStackList();
                }
            } else if (!this.prevSlurry.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                this.prevSlurry = MekanismAPI.EMPTY_CHEMICAL_HOLDER;
                this.iterStacks.clear();
                this.slotDisplay.updateStackList();
            }
        }
    }

    @Override
    protected List<Component> getRenderStrings() {
        ChemicalStack chemical = this.oreInfo.getInputChemical();
        if (!chemical.isEmpty()) {
            ChemicalCrystallizerRecipe recipe;
            ItemStack renderStack;
            ItemStack itemStack = renderStack = this.oreInfo.usesSequencedDisplay() && this.slotDisplay != null ? this.slotDisplay.getRenderStack() : this.oreInfo.getRenderStack();
            MutableComponent recipeComponent = !renderStack.isEmpty() ? MekanismLang.GENERIC_PARENTHESIS.translate(renderStack) : ((recipe = this.oreInfo.getRecipe()) == null ? MekanismLang.NO_RECIPE.translate() : MekanismLang.GENERIC_PARENTHESIS.translate(recipe.getOutput(chemical)));
            return List.of(chemical.getTextComponent(), recipeComponent);
        }
        return Collections.emptyList();
    }

    @Override
    protected int getMaxTextWidth(int row) {
        if (row == 0) {
            return this.width - this.slot.getWidth();
        }
        return super.getMaxTextWidth(row);
    }

    public static interface IOreInfo {
        @NotNull
        public ChemicalStack getInputChemical();

        @Nullable
        public ChemicalCrystallizerRecipe getRecipe();

        @NotNull
        default public ItemStack getRenderStack() {
            return ItemStack.EMPTY;
        }

        default public boolean usesSequencedDisplay() {
            return true;
        }
    }
}

