/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.model.ModelPartData;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModelJetpack
extends MekanismJavaModel {
    public static final ModelLayerLocation JETPACK_LAYER = new ModelLayerLocation(Mekanism.rl("jetpack"), "main");
    private static final ResourceLocation JETPACK_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "jetpack.png");
    protected static final ModelPartData PACK_TOP = new ModelPartData("packTop", CubeListBuilder.create().texOffs(92, 28).addBox(-4.0f, 0.0f, 4.0f, 8.0f, 4.0f, 1.0f), PartPose.rotation((float)0.2094395f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    protected static final ModelPartData PACK_BOTTOM = new ModelPartData("packBottom", CubeListBuilder.create().texOffs(92, 42).addBox(-4.0f, 4.1f, 1.5f, 8.0f, 4.0f, 4.0f), PartPose.rotation((float)-0.0872665f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    protected static final ModelPartData PACK_MID = new ModelPartData("packMid", CubeListBuilder.create().texOffs(92, 34).addBox(-4.0f, 3.3f, 1.5f, 8.0f, 1.0f, 4.0f), new ModelPartData[0]);
    protected static final ModelPartData PACK_CORE = new ModelPartData("packCore", CubeListBuilder.create().texOffs(69, 2).addBox(-3.5f, 3.0f, 2.0f, 7.0f, 1.0f, 3.0f), new ModelPartData[0]);
    protected static final ModelPartData WING_SUPPORT_L = new ModelPartData("wingSupportL", CubeListBuilder.create().texOffs(71, 55).addBox(3.0f, -1.0f, 2.2f, 7.0f, 2.0f, 2.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.2792527f), new ModelPartData[0]);
    protected static final ModelPartData WING_SUPPORT_R = new ModelPartData("wingSupportR", CubeListBuilder.create().texOffs(71, 55).addBox(-10.0f, -1.0f, 2.2f, 7.0f, 2.0f, 2.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)-0.2792527f), new ModelPartData[0]);
    protected static final ModelPartData PACK_TOP_REAR = new ModelPartData("packTopRear", CubeListBuilder.create().texOffs(106, 28).addBox(-4.0f, 1.0f, 1.0f, 8.0f, 3.0f, 3.0f), PartPose.rotation((float)0.2094395f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    protected static final ModelPartData EXTENDO_SUPPORT_L = new ModelPartData("extendoSupportL", CubeListBuilder.create().texOffs(94, 16).addBox(8.0f, -0.2f, 2.5f, 9.0f, 1.0f, 1.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.2792527f), new ModelPartData[0]);
    protected static final ModelPartData EXTENDO_SUPPORT_R = new ModelPartData("extendoSupportR", CubeListBuilder.create().texOffs(94, 16).addBox(-17.0f, -0.2f, 2.5f, 9.0f, 1.0f, 1.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)-0.2792527f), new ModelPartData[0]);
    protected static final ModelPartData WING_BLADE_L = new ModelPartData("wingBladeL", CubeListBuilder.create().texOffs(62, 5).addBox(3.3f, 1.1f, 3.0f, 14.0f, 2.0f, 0.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.2094395f), new ModelPartData[0]);
    protected static final ModelPartData WING_BLADE_R = new ModelPartData("wingBladeR", CubeListBuilder.create().texOffs(62, 5).addBox(-17.3f, 1.1f, 3.0f, 14.0f, 2.0f, 0.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)-0.2094395f), new ModelPartData[0]);
    protected static final ModelPartData PACK_DOODAD_2 = new ModelPartData("packDoodad2", CubeListBuilder.create().texOffs(116, 0).addBox(1.0f, 0.5f, 4.2f, 2.0f, 1.0f, 1.0f), PartPose.rotation((float)0.2094395f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    protected static final ModelPartData PACK_DOODAD_3 = new ModelPartData("packDoodad3", CubeListBuilder.create().texOffs(116, 0).addBox(1.0f, 2.0f, 4.2f, 2.0f, 1.0f, 1.0f), PartPose.rotation((float)0.2094395f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    protected static final ModelPartData BOTTOM_THRUSTER = new ModelPartData("bottomThruster", CubeListBuilder.create().texOffs(68, 26).addBox(-3.0f, 8.0f, 2.333333f, 6.0f, 1.0f, 2.0f), new ModelPartData[0]);
    protected static final ModelPartData LIGHT_1 = new ModelPartData("light1", CubeListBuilder.create().texOffs(55, 2).addBox(2.0f, 6.55f, 4.0f, 1.0f, 1.0f, 1.0f), new ModelPartData[0]);
    protected static final ModelPartData LIGHT_2 = new ModelPartData("light2", CubeListBuilder.create().texOffs(55, 2).addBox(0.0f, 6.55f, 4.0f, 1.0f, 1.0f, 1.0f), new ModelPartData[0]);
    protected static final ModelPartData LIGHT_3 = new ModelPartData("light3", CubeListBuilder.create().texOffs(55, 2).addBox(-3.0f, 6.55f, 4.0f, 1.0f, 1.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData THRUSTER_LEFT = ModelJetpack.thrusterLeft(-3.0f);
    private static final ModelPartData THRUSTER_RIGHT = ModelJetpack.thrusterRight(-3.0f);
    private static final ModelPartData FUEL_TUBE_RIGHT = ModelJetpack.fuelTubeRight(-3.0f);
    private static final ModelPartData FUEL_TUBE_LEFT = ModelJetpack.fuelTubeLeft(-3.0f);
    private final RenderType frameRenderType = this.renderType(JETPACK_TEXTURE);
    private final RenderType wingRenderType = MekanismRenderType.JETPACK_GLASS.apply(JETPACK_TEXTURE);
    private final List<ModelPart> parts;
    private final List<ModelPart> litParts;
    private final List<ModelPart> wingParts;

    public static LayerDefinition createLayerDefinition() {
        return ModelJetpack.createLayerDefinition(128, 64, PACK_TOP, PACK_BOTTOM, THRUSTER_LEFT, THRUSTER_RIGHT, FUEL_TUBE_RIGHT, FUEL_TUBE_LEFT, PACK_MID, PACK_CORE, WING_SUPPORT_L, WING_SUPPORT_R, PACK_TOP_REAR, EXTENDO_SUPPORT_L, EXTENDO_SUPPORT_R, WING_BLADE_L, WING_BLADE_R, PACK_DOODAD_2, PACK_DOODAD_3, BOTTOM_THRUSTER, LIGHT_1, LIGHT_2, LIGHT_3);
    }

    public ModelJetpack(EntityModelSet entityModelSet) {
        this(entityModelSet.bakeLayer(JETPACK_LAYER));
    }

    protected ModelJetpack(ModelPart root) {
        super(RenderType::entitySolid);
        this.parts = ModelJetpack.getRenderableParts(root, PACK_TOP, PACK_BOTTOM, THRUSTER_LEFT, THRUSTER_RIGHT, FUEL_TUBE_RIGHT, FUEL_TUBE_LEFT, PACK_MID, WING_SUPPORT_L, WING_SUPPORT_R, PACK_TOP_REAR, EXTENDO_SUPPORT_L, EXTENDO_SUPPORT_R, PACK_DOODAD_2, PACK_DOODAD_3, BOTTOM_THRUSTER);
        this.litParts = ModelJetpack.getRenderableParts(root, LIGHT_1, LIGHT_2, LIGHT_3, PACK_CORE);
        this.wingParts = ModelJetpack.getRenderableParts(root, WING_BLADE_L, WING_BLADE_R);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource renderer, int light, int overlayLight, boolean hasEffect) {
        this.renderToBuffer(poseStack, ModelJetpack.getVertexConsumer(renderer, this.frameRenderType, hasEffect), light, overlayLight, -1);
        ModelJetpack.renderPartsToBuffer(this.wingParts, poseStack, ModelJetpack.getVertexConsumer(renderer, this.wingRenderType, hasEffect), 0xF000F0, overlayLight, 0x33FFFFFF);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlayLight, int color) {
        ModelJetpack.renderPartsToBuffer(this.parts, poseStack, vertexConsumer, light, overlayLight, color);
        ModelJetpack.renderPartsToBuffer(this.litParts, poseStack, vertexConsumer, 0xF000F0, overlayLight, color);
    }

    protected static ModelPartData thrusterLeft(float fuelZ) {
        return new ModelPartData("thrusterLeft", CubeListBuilder.create().texOffs(69, 30).addBox(7.8f, 1.5f, fuelZ - 0.5f, 3.0f, 3.0f, 3.0f), PartPose.rotation((float)0.7853982f, (float)-0.715585f, (float)0.3490659f), new ModelPartData[0]);
    }

    protected static ModelPartData thrusterRight(float fuelZ) {
        return new ModelPartData("thrusterRight", CubeListBuilder.create().texOffs(69, 30).addBox(-10.8f, 1.5f, fuelZ - 0.5f, 3.0f, 3.0f, 3.0f), PartPose.rotation((float)0.7853982f, (float)0.715585f, (float)-0.3490659f), new ModelPartData[0]);
    }

    protected static ModelPartData fuelTubeRight(float fuelZ) {
        return new ModelPartData("fuelTubeRight", CubeListBuilder.create().texOffs(92, 23).addBox(-11.2f, 2.0f, fuelZ, 8.0f, 2.0f, 2.0f), PartPose.rotation((float)0.7853982f, (float)0.715585f, (float)-0.3490659f), new ModelPartData[0]);
    }

    protected static ModelPartData fuelTubeLeft(float fuelZ) {
        return new ModelPartData("fuelTubeLeft", CubeListBuilder.create().texOffs(92, 23).addBox(3.2f, 2.0f, fuelZ, 8.0f, 2.0f, 2.0f), PartPose.rotation((float)0.7853982f, (float)-0.715585f, (float)0.3490659f), new ModelPartData[0]);
    }
}

