/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;

public class RadiationParticle
extends SmokeParticle {
    private RadiationParticle(ClientLevel world, double posX, double posY, double posZ, double velX, double velY, double velZ, SpriteSet sprite) {
        super(world, posX, posY, posZ, velX, velY, velZ, 1.0f, sprite);
        this.setColor(0.2f, 0.66f, 0.32f);
    }

    public int getLightColor(float partialTick) {
        return 190 + (int)(20.0f * (1.0f - ((Double)Minecraft.getInstance().options.gamma().get()).floatValue()));
    }

    public void render(@NotNull VertexConsumer vertexBuilder, @NotNull Camera renderInfo, float partialTicks) {
        if (this.age > 0) {
            super.render(vertexBuilder, renderInfo, partialTicks);
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RadiationParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

