/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import mekanism.api.MekanismAPITags;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.data.RenderData;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalRenderData
extends RenderData {
    public final Holder<Chemical> chemical;

    public ChemicalRenderData(BlockPos renderLocation, int width, int height, int length, Holder<Chemical> chemical) {
        super(renderLocation, width, height, length);
        this.chemical = chemical;
    }

    @Override
    public int getColorARGB(float scale) {
        return MekanismRenderer.getColorARGB(this.chemical, scale);
    }

    @Override
    public TextureAtlasSprite getTexture() {
        return MekanismRenderer.getChemicalTexture(this.chemical);
    }

    @Override
    public boolean isGaseous() {
        return this.chemical.is(MekanismAPITags.Chemicals.GASEOUS) || ((Chemical)this.chemical.value()).isGaseousLegacy();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.chemical.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o.getClass() == ChemicalRenderData.class && this.equalsCommonChemical(o);
    }

    protected boolean equalsCommonChemical(@NotNull Object o) {
        return super.equals(o) && this.chemical.is(((ChemicalRenderData)o).chemical);
    }

    public static class Scaled
    extends ChemicalRenderData
    implements RenderData.ScaledRenderData {
        private final float scale;

        public Scaled(BlockPos renderLocation, int width, int height, int length, Holder<Chemical> chemical, float scale) {
            super(renderLocation, width, height, length, chemical);
            this.scale = scale;
        }

        @Override
        public float scale() {
            return this.scale;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            return o.getClass() == Scaled.class && this.equalsCommonChemical(o) && this.scale == ((Scaled)o).scale;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Float.hashCode(this.scale);
        }
    }
}

