/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.functions.ToFloatFunction;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.Vertex;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class QuadUtils {
    private static final float eps = 0.00390625f;

    private QuadUtils() {
    }

    public static List<Quad> unpack(List<BakedQuad> quads) {
        return quads.stream().map(Quad::new).toList();
    }

    public static List<BakedQuad> bake(List<Quad> quads) {
        return quads.stream().map(Quad::bake).toList();
    }

    public static List<Quad> flip(List<Quad> quads) {
        return quads.stream().map(Quad::flip).toList();
    }

    public static List<Quad> transformQuads(List<Quad> orig, QuadTransformation transformation) {
        ArrayList<Quad> list = new ArrayList<Quad>(orig.size());
        for (Quad quad : orig) {
            transformation.transform(quad);
            list.add(quad);
        }
        return list;
    }

    public static List<BakedQuad> transformBakedQuads(List<BakedQuad> orig, QuadTransformation transformation) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>(orig.size());
        for (BakedQuad bakedQuad : orig) {
            Quad quad = new Quad(bakedQuad);
            if (transformation.transform(quad)) {
                list.add(quad.bake());
                continue;
            }
            list.add(bakedQuad);
        }
        return list;
    }

    public static List<BakedQuad> transformAndBake(List<Quad> orig, QuadTransformation transformation) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>(orig.size());
        for (Quad quad : orig) {
            transformation.transform(quad);
            list.add(quad.bake());
        }
        return list;
    }

    public static void remapUVs(Quad quad, TextureAtlasSprite newTexture) {
        TextureAtlasSprite texture = quad.getTexture();
        float uMin = texture.getU0();
        float uMax = texture.getU1();
        float vMin = texture.getV0();
        float vMax = texture.getV1();
        for (Vertex v : quad.getVertices()) {
            float newU = (v.getTexU() - uMin) / (uMax - uMin);
            float newV = (v.getTexV() - vMin) / (vMax - vMin);
            v.texRaw(newTexture.getU(newU), newTexture.getV(newV));
        }
    }

    public static void contractUVs(Quad quad) {
        TextureAtlasSprite texture = quad.getTexture();
        float sizeX = (float)texture.contents().width() / (texture.getU1() - texture.getU0());
        float sizeY = (float)texture.contents().height() / (texture.getV1() - texture.getV0());
        float ep = 1.0f / (Math.max(sizeX, sizeY) * 256.0f);
        float[] newUs = QuadUtils.contract(quad, Vertex::getTexU, ep);
        float[] newVs = QuadUtils.contract(quad, Vertex::getTexV, ep);
        for (int i = 0; i < quad.getVertices().length; ++i) {
            quad.getVertices()[i].texRaw(newUs[i], newVs[i]);
        }
    }

    private static float[] contract(Quad quad, ToFloatFunction<Vertex> uvf, float ep) {
        int v;
        float center = 0.0f;
        float[] ret = new float[4];
        for (v = 0; v < 4; ++v) {
            center += uvf.applyAsFloat(quad.getVertices()[v]);
        }
        center /= 4.0f;
        for (v = 0; v < 4; ++v) {
            float shifted;
            float orig = uvf.applyAsFloat(quad.getVertices()[v]);
            float delta = orig - (shifted = orig * 0.99609375f + center * 0.00390625f);
            if (Math.abs(delta) < ep) {
                float centerDelta = Math.abs(orig - center);
                shifted = centerDelta < 2.0f * ep ? (orig + center) / 2.0f : orig + (delta < 0.0f ? ep : -ep);
            }
            ret[v] = shifted;
        }
        return ret;
    }
}

