/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@NothingNullByDefault
public class RenderNutritionalLiquifier
extends MekanismTileEntityRenderer<TileEntityNutritionalLiquifier> {
    private static final Int2ObjectMap<MekanismRenderer.Model3D> cachedModels = new Int2ObjectOpenHashMap();
    private static final Map<TileEntityNutritionalLiquifier, PseudoParticleData> particles = new WeakHashMap<TileEntityNutritionalLiquifier, PseudoParticleData>();
    private static final int stages = 40;
    private static final float BLADE_SPEED = 25.0f;
    private static final float ROTATE_SPEED = 10.0f;

    public static void resetCachedModels() {
        cachedModels.clear();
    }

    public RenderNutritionalLiquifier(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityNutritionalLiquifier tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        ItemStack stack;
        boolean active;
        if (!tile.fluidTank.isEmpty()) {
            FluidStack paste = tile.fluidTank.getFluid();
            float fluidScale = (float)paste.getAmount() / (float)tile.fluidTank.getCapacity();
            MekanismRenderer.renderObject(this.getPasteModel(paste, fluidScale), matrix, renderer.getBuffer(Sheets.translucentCullBlockSheet()), MekanismRenderer.getColorARGB(paste, fluidScale), light, overlayLight, RenderResizableCuboid.FaceDisplay.FRONT, this.getCamera(), tile.getBlockPos());
        }
        if (active = tile.getActive()) {
            matrix.pushPose();
            matrix.translate(0.5, 0.5, 0.5);
            matrix.mulPose(Axis.YP.rotationDegrees(((float)tile.getLevel().getGameTime() + partialTick) * 25.0f % 360.0f));
            matrix.translate(-0.5, -0.5, -0.5);
            PoseStack.Pose entry = matrix.last();
            VertexConsumer bladeBuffer = renderer.getBuffer(Sheets.solidBlockSheet());
            for (BakedQuad quad : MekanismModelCache.INSTANCE.LIQUIFIER_BLADE.getQuads(tile.getLevel().random)) {
                bladeBuffer.putBulkData(entry, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlayLight);
            }
            matrix.popPose();
        }
        if (!(stack = tile.getRenderStack()).isEmpty()) {
            matrix.pushPose();
            matrix.translate(0.5, 0.6, 0.5);
            if (active) {
                matrix.mulPose(Axis.YP.rotationDegrees(((float)tile.getLevel().getGameTime() + partialTick) * 10.0f % 360.0f));
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlayLight, matrix, renderer, tile.getLevel(), MathUtils.clampToInt(tile.getBlockPos().asLong()));
            matrix.popPose();
            if (active && Minecraft.getInstance().options.particles().get() != ParticleStatus.MINIMAL) {
                PseudoParticleData pseudoParticles = particles.computeIfAbsent(tile, t -> new PseudoParticleData());
                if (this.isTickingNormally(tile)) {
                    int rate;
                    if (pseudoParticles.lastTick != tile.getLevel().getGameTime()) {
                        pseudoParticles.lastTick = tile.getLevel().getGameTime();
                        pseudoParticles.particles.removeIf(PseudoParticle::tick);
                    }
                    int n = rate = Minecraft.getInstance().options.particles().get() == ParticleStatus.DECREASED ? 10 : 3;
                    if (tile.getLevel().getGameTime() % (long)rate == 0L) {
                        pseudoParticles.particles.add(new PseudoParticle(tile.getLevel(), stack));
                    }
                }
                VertexConsumer buffer = renderer.getBuffer(MekanismRenderType.NUTRITIONAL_PARTICLE);
                matrix.pushPose();
                matrix.translate(0.5, 0.55, 0.5);
                Matrix4f matrix4f = matrix.last().pose();
                for (PseudoParticle particle : pseudoParticles.particles) {
                    particle.render(matrix4f, buffer, partialTick, light);
                }
                matrix.popPose();
            } else {
                particles.remove(tile);
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "nutritionalLiquifier";
    }

    private MekanismRenderer.Model3D getPasteModel(FluidStack paste, float fluidScale) {
        int stage = ModelRenderer.getStage(paste, 40, (double)fluidScale);
        MekanismRenderer.Model3D model = (MekanismRenderer.Model3D)cachedModels.get(stage);
        if (model == null) {
            model = new MekanismRenderer.Model3D().setTexture(MekanismRenderer.getFluidTexture(paste, MekanismRenderer.FluidTextureType.STILL)).setSideRender(Direction.DOWN, false).setSideRender(Direction.UP, stage < 40).xBounds(0.001f, 0.999f).yBounds(0.313f, 0.313f + 0.624f * ((float)stage / 40.0f)).zBounds(0.001f, 0.999f);
            cachedModels.put(stage, (Object)model);
        }
        return model;
    }

    private static class PseudoParticleData {
        private final List<PseudoParticle> particles = new ArrayList<PseudoParticle>();
        private long lastTick;

        private PseudoParticleData() {
        }
    }

    private static class PseudoParticle {
        private static final AABB INITIAL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        private final TextureAtlasSprite sprite;
        private final float quadSize;
        private final float uo;
        private final float vo;
        protected double xo;
        protected double yo;
        protected double zo;
        protected double x;
        protected double y;
        protected double z;
        protected double xd;
        protected double yd;
        protected double zd;
        protected int lifetime;
        protected int age;
        protected float gravity;
        private AABB bb = INITIAL_AABB;
        protected float bbWidth = 0.6f;
        protected float bbHeight = 1.8f;

        protected PseudoParticle(Level world, ItemStack stack) {
            ClientLevel level;
            this.setSize(0.2f, 0.2f);
            this.x = ((double)world.random.nextFloat() - 0.5) * 0.3;
            this.y = ((double)world.random.nextFloat() - 0.5) * 0.3;
            this.z = ((double)world.random.nextFloat() - 0.5) * 0.3;
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.lifetime = (int)(4.0f / (world.random.nextFloat() * 0.9f + 0.1f));
            this.xd = (Math.random() * 2.0 - 1.0) * 0.4;
            this.yd = (Math.random() * 2.0 - 1.0) * 0.4;
            this.zd = (Math.random() * 2.0 - 1.0) * 0.4;
            float f = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
            float f1 = (float)Mth.length((double)this.xd, (double)this.yd, (double)this.zd);
            this.xd = this.xd / (double)f1 * (double)f * 0.4;
            this.yd = this.yd / (double)f1 * (double)f * 0.4 + 0.1;
            this.zd = this.zd / (double)f1 * (double)f * 0.4;
            BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(stack, world, null, 0);
            BakedModel override = model.getOverrides().resolve(model, stack, world instanceof ClientLevel ? (level = (ClientLevel)world) : null, null, 0);
            if (override != null) {
                model = override;
            }
            this.sprite = model.getParticleIcon(ModelData.EMPTY);
            this.gravity = 1.0f;
            this.quadSize = 0.1f * (world.random.nextFloat() * 0.5f + 0.5f);
            this.uo = world.random.nextFloat() * 3.0f;
            this.vo = world.random.nextFloat() * 3.0f;
            this.xd *= 0.1;
            this.yd *= 0.1;
            this.zd *= 0.1;
            this.xd += ((double)world.random.nextFloat() - 0.5) * 0.075;
            this.yd += Math.random() * 0.1 + 0.05;
            this.zd += ((double)world.random.nextFloat() - 0.5) * 0.075;
        }

        public boolean tick() {
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            if (this.age++ >= this.lifetime || this.y < -0.25) {
                return true;
            }
            this.yd -= 0.04 * (double)this.gravity;
            if (this.xd != 0.0 || this.yd != 0.0 || this.zd != 0.0) {
                this.bb = this.bb.move(this.xd, this.yd, this.zd);
                this.x = (this.bb.minX + this.bb.maxX) / 2.0;
                this.y = this.bb.minY;
                this.z = (this.bb.minZ + this.bb.maxZ) / 2.0;
            }
            this.xd *= 0.98;
            this.yd *= 0.98;
            this.zd *= 0.98;
            return false;
        }

        public void render(Matrix4f matrix, VertexConsumer buffer, float partialTicks, int light) {
            Camera camera = Minecraft.getInstance().getEntityRenderDispatcher().camera;
            Quaternionf quaternion = new Quaternionf();
            SingleQuadParticle.FacingCameraMode.LOOKAT_XYZ.setRotation(quaternion, camera, partialTicks);
            float f = (float)Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x);
            float f1 = (float)Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y);
            float f2 = (float)Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z);
            this.renderRotatedQuad(matrix, buffer, quaternion, f, f1, f2, light);
        }

        protected void renderRotatedQuad(Matrix4f matrix, VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, int light) {
            float minU = this.getU0();
            float maxU = this.getU1();
            float minV = this.getV0();
            float maxV = this.getV1();
            this.renderVertex(matrix, buffer, quaternion, x, y, z, 1.0f, -1.0f, maxU, maxV, light);
            this.renderVertex(matrix, buffer, quaternion, x, y, z, 1.0f, 1.0f, maxU, minV, light);
            this.renderVertex(matrix, buffer, quaternion, x, y, z, -1.0f, 1.0f, minU, minV, light);
            this.renderVertex(matrix, buffer, quaternion, x, y, z, -1.0f, -1.0f, minU, maxV, light);
        }

        private void renderVertex(Matrix4f matrix, VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float u, float v, int light) {
            Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)quaternion).mul(this.quadSize).add(x, y, z);
            buffer.addVertex(matrix, vector3f.x(), vector3f.y(), vector3f.z()).setUv(u, v).setColor(255, 255, 255, 255).setLight(light);
        }

        protected float getU0() {
            return this.sprite.getU((this.uo + 1.0f) / 4.0f);
        }

        protected float getU1() {
            return this.sprite.getU(this.uo / 4.0f);
        }

        protected float getV0() {
            return this.sprite.getV(this.vo / 4.0f);
        }

        protected float getV1() {
            return this.sprite.getV((this.vo + 1.0f) / 4.0f);
        }

        protected void setSize(float particleWidth, float particleHeight) {
            if (particleWidth != this.bbWidth || particleHeight != this.bbHeight) {
                this.bbWidth = particleWidth;
                this.bbHeight = particleHeight;
                double d0 = (this.bb.minX + this.bb.maxX - (double)particleWidth) / 2.0;
                double d1 = (this.bb.minZ + this.bb.maxZ - (double)particleWidth) / 2.0;
                this.bb = new AABB(d0, this.bb.minY, d1, d0 + (double)this.bbWidth, this.bb.minY + (double)this.bbHeight, d1 + (double)this.bbWidth);
            }
        }
    }
}

