/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers;

import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.IAttachedContainers;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public abstract class ComponentBackedContainer<TYPE, ATTACHED extends IAttachedContainers<TYPE, ATTACHED>>
implements IContentsListener {
    protected final ItemStack attachedTo;
    protected final int containerIndex;

    protected ComponentBackedContainer(ItemStack attachedTo, int containerIndex) {
        this.attachedTo = attachedTo;
        this.containerIndex = containerIndex;
    }

    protected abstract TYPE copy(TYPE var1);

    protected abstract boolean isEmpty(TYPE var1);

    protected abstract ContainerType<?, ATTACHED, ?> containerType();

    protected ATTACHED getAttached() {
        return this.containerType().getOrEmpty(this.attachedTo);
    }

    protected TYPE getContents(ATTACHED attached) {
        return attached.getOrDefault(this.containerIndex);
    }

    protected void setContents(ATTACHED attached, TYPE value) {
        if (attached.isEmpty() && (attached = this.containerType().createNewAttachment(this.attachedTo)).isEmpty()) {
            return;
        }
        if (this.shouldUpdate(attached, value)) {
            this.attachedTo.set(this.containerType().getComponentType(), attached.with(this.containerIndex, this.copy(value)));
            this.onContentsChanged();
        }
    }

    protected boolean shouldUpdate(ATTACHED attached, TYPE value) {
        return !this.isEmpty(value) || !this.isEmpty(this.getContents(attached));
    }

    @Override
    public void onContentsChanged() {
    }
}

