/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.fluid;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.fluid.AttachedFluids;
import mekanism.common.attachments.containers.fluid.ComponentBackedFluidTank;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.tier.FluidTankTier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public class ComponentBackedFluidTankFluidTank
extends ComponentBackedFluidTank {
    private final boolean isCreative;

    public static ComponentBackedFluidTankFluidTank create(ContainerType<?, ?, ?> ignored, ItemStack attachedTo, int tankIndex) {
        Item item = attachedTo.getItem();
        if (!(item instanceof ItemBlockFluidTank)) {
            throw new IllegalStateException("Attached to should always be a fluid tank item");
        }
        ItemBlockFluidTank item2 = (ItemBlockFluidTank)item;
        return new ComponentBackedFluidTankFluidTank(attachedTo, tankIndex, item2.getTier());
    }

    private ComponentBackedFluidTankFluidTank(ItemStack attachedTo, int tankIndex, FluidTankTier tier) {
        super(attachedTo, tankIndex, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), tier::getOutput, tier::getStorage);
        this.isCreative = tier == FluidTankTier.CREATIVE;
    }

    @Override
    public FluidStack insert(FluidStack stack, Action action, AutomationType automationType) {
        return super.insert(stack, action.combine(!this.isCreative), automationType);
    }

    @Override
    public FluidStack extract(AttachedFluids attachedFluids, FluidStack stored, int amount, Action action, AutomationType automationType) {
        return super.extract(attachedFluids, stored, amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public int setStackSize(AttachedFluids attachedFluids, FluidStack stored, int amount, Action action) {
        return super.setStackSize(attachedFluids, stored, amount, action.combine(!this.isCreative));
    }
}

