/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.qio;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.UUID;
import java.util.function.LongBinaryOperator;
import java.util.stream.LongStream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

@NothingNullByDefault
public record DriveContents(Object2LongSortedMap<UUID> namedItemMap) {
    public static final DriveContents EMPTY = new DriveContents((Object2LongSortedMap<UUID>)Object2LongSortedMaps.emptyMap());
    private static final LongBinaryOperator SUM = Long::sum;
    public static final Codec<DriveContents> CODEC = Codec.LONG_STREAM.xmap(stream -> DriveContents.readSerializedItemMap(stream.toArray()), contents -> LongStream.of(contents.serializeItemMap()));
    public static final StreamCodec<ByteBuf, DriveContents> STREAM_CODEC = ByteBufCodecs.map(Object2LongLinkedOpenHashMap::new, (StreamCodec)UUIDUtil.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_LONG).map(DriveContents::new, DriveContents::namedItemMap);

    public DriveContents(Object2LongSortedMap<UUID> namedItemMap) {
        this.namedItemMap = namedItemMap = Object2LongSortedMaps.unmodifiable(namedItemMap);
    }

    public static DriveContents create(QIODriveData data) {
        Object2LongMap<HashedItem> itemMap = data.getItemMap();
        if (itemMap.isEmpty()) {
            return EMPTY;
        }
        Object2LongLinkedOpenHashMap namedItemMap = new Object2LongLinkedOpenHashMap(itemMap.size());
        ObjectIterator iterator = Object2LongMaps.fastIterator(data.getItemMap());
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            namedItemMap.put((Object)QIOGlobalItemLookup.INSTANCE.getOrTrackUUID((HashedItem)entry.getKey()), entry.getLongValue());
        }
        return new DriveContents((Object2LongSortedMap<UUID>)namedItemMap);
    }

    public void loadItemMap(QIODriveData data) {
        Object2LongMap<HashedItem> itemMap = data.getItemMap();
        ObjectIterator iterator = Object2LongMaps.fastIterator(this.namedItemMap);
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            HashedItem type = QIOGlobalItemLookup.INSTANCE.getTypeByUUID((UUID)entry.getKey());
            if (type == null) continue;
            itemMap.put((Object)type, entry.getLongValue());
        }
    }

    private long[] serializeItemMap() {
        int i = 0;
        long[] serializedItemMap = new long[3 * this.namedItemMap.size()];
        ObjectIterator iterator = Object2LongMaps.fastIterator(this.namedItemMap);
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            UUID uuid = (UUID)entry.getKey();
            serializedItemMap[i++] = uuid.getMostSignificantBits();
            serializedItemMap[i++] = uuid.getLeastSignificantBits();
            serializedItemMap[i++] = entry.getLongValue();
        }
        return serializedItemMap;
    }

    private static DriveContents readSerializedItemMap(long[] serializedItemMap) {
        if (serializedItemMap.length > 0 && serializedItemMap.length % 3 == 0) {
            Object2LongLinkedOpenHashMap namedItemMap = new Object2LongLinkedOpenHashMap();
            boolean hasAliases = QIOGlobalItemLookup.INSTANCE.hasAliases();
            for (int i = 0; i < serializedItemMap.length; ++i) {
                UUID savedUUID = new UUID(serializedItemMap[i++], serializedItemMap[i++]);
                long storedCount = serializedItemMap[i];
                if (!hasAliases) {
                    namedItemMap.put((Object)savedUUID, storedCount);
                    continue;
                }
                UUID winningId = QIOGlobalItemLookup.INSTANCE.getWinningId(savedUUID);
                namedItemMap.mergeLong((Object)winningId, storedCount, SUM);
            }
            return new DriveContents((Object2LongSortedMap<UUID>)namedItemMap);
        }
        return EMPTY;
    }
}

