/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.lib.transmitter.TransmissionType;
import org.jetbrains.annotations.NotNull;

public record AttributeSideConfig(@NotNull Set<TransmissionType> supportedTypes) implements Attribute
{
    public static final AttributeSideConfig ELECTRIC_MACHINE = AttributeSideConfig.create(TransmissionType.ITEM, TransmissionType.ENERGY);
    public static final AttributeSideConfig ADVANCED_ELECTRIC_MACHINE = AttributeSideConfig.create(TransmissionType.ITEM, TransmissionType.CHEMICAL, TransmissionType.ENERGY);

    public static AttributeSideConfig create(TransmissionType ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("Expected at least one supported transmission type");
        }
        LinkedHashSet<TransmissionType> supported = new LinkedHashSet<TransmissionType>(types.length);
        Collections.addAll(supported, types);
        return new AttributeSideConfig(supported);
    }
}

