/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical;

import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.datamaps.chemical.attribute.ChemicalRadioactivity;
import mekanism.api.datamaps.chemical.attribute.IChemicalAttribute;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.capabilities.chemical.VariableCapacityChemicalTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.TileEntityRadioactiveWasteBarrel;
import mekanism.common.util.WorldUtils;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class StackedWasteBarrel
extends VariableCapacityChemicalTank {
    private static final ChemicalAttributeValidator ATTRIBUTE_VALIDATOR = new ChemicalAttributeValidator.ChemicalAttributeValidatorLegacyAdapter(){

        @Override
        public boolean validate(IChemicalAttribute attr) {
            return attr instanceof ChemicalRadioactivity;
        }

        @Override
        public boolean process(Chemical chemical) {
            return chemical.isRadioactive();
        }
    };
    private final TileEntityRadioactiveWasteBarrel tile;

    public static StackedWasteBarrel create(TileEntityRadioactiveWasteBarrel tile, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tile, "Radioactive Waste Barrel tile entity cannot be null");
        return new StackedWasteBarrel(tile, listener);
    }

    protected StackedWasteBarrel(TileEntityRadioactiveWasteBarrel tile, @Nullable IContentsListener listener) {
        super(MekanismConfig.general.radioactiveWasteBarrelMaxChemical, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), ATTRIBUTE_VALIDATOR, listener);
        this.tile = tile;
    }

    @Override
    public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
        TileEntityRadioactiveWasteBarrel tileAbove;
        ChemicalStack remainder = super.insert(stack, action, automationType);
        if (!remainder.isEmpty() && ChemicalStack.isSameChemical(this.stored, remainder) && (tileAbove = WorldUtils.getTileEntity(TileEntityRadioactiveWasteBarrel.class, (BlockGetter)this.tile.getLevel(), this.tile.getBlockPos().above())) != null) {
            remainder = tileAbove.getChemicalTank().insert(remainder, action, AutomationType.EXTERNAL);
        }
        return remainder;
    }

    @Override
    public long growStack(long amount, Action action) {
        TileEntityRadioactiveWasteBarrel tileAbove;
        long grownAmount = super.growStack(amount, action);
        if (amount > 0L && grownAmount < amount && !this.tile.getActive() && (tileAbove = WorldUtils.getTileEntity(TileEntityRadioactiveWasteBarrel.class, (BlockGetter)this.tile.getLevel(), this.tile.getBlockPos().above())) != null) {
            long leftOverToInsert = amount - grownAmount;
            ChemicalStack remainder = tileAbove.getChemicalTank().insert(this.stored.copyWithAmount(leftOverToInsert), action, AutomationType.EXTERNAL);
            grownAmount += leftOverToInsert - remainder.getAmount();
        }
        return grownAmount;
    }
}

