/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.Predicate;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkTicketLevelUpdatedEvent;
import org.jetbrains.annotations.Nullable;

public class ChunkCommand {
    private static final String NAME_PARAM = "name";
    private static final String POS_PARAM = "pos";
    private static final LangData WATCH = new LangData(MekanismLang.COMMAND_CHUNK_WATCH, MekanismLang.COMMAND_CHUNK_WATCH_NAMED);
    private static final LangData UNWATCH = new LangData(MekanismLang.COMMAND_CHUNK_UNWATCH, MekanismLang.COMMAND_CHUNK_UNWATCH_NAMED);
    private static final LangData LOADED = new LangData(MekanismLang.COMMAND_CHUNK_LOADED, MekanismLang.COMMAND_CHUNK_LOADED_NAMED);
    private static final LangData UNLOADED = new LangData(MekanismLang.COMMAND_CHUNK_UNLOADED, MekanismLang.COMMAND_CHUNK_UNLOADED_NAMED);
    private static final Long2ObjectMap<ChunkWatchSettings> chunkWatchers = new Long2ObjectOpenHashMap();

    private ChunkCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        NeoForge.EVENT_BUS.register(ChunkCommand.class);
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chunk").requires((Predicate)MekanismPermissions.COMMAND_CHUNK)).then(WatchCommand.register())).then(UnwatchCommand.register())).then(ClearCommand.register())).then(FlushCommand.register());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, LOADED);
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, UNLOADED);
    }

    @SubscribeEvent
    public static void onTicketLevelChange(ChunkTicketLevelUpdatedEvent event) {
        if (chunkWatchers.isEmpty() || event.getLevel().players().isEmpty()) {
            return;
        }
        ChunkWatchSettings settings = (ChunkWatchSettings)chunkWatchers.get(event.getChunkPos());
        if (settings != null) {
            Component message = settings.translateTicketLevel(event.getOldTicketLevel(), event.getNewTicketLevel());
            for (Player player : event.getLevel().players()) {
                player.sendSystemMessage(message);
            }
        }
    }

    private static void handleChunkEvent(ChunkEvent event, LangData direction) {
        LevelAccessor level = event.getLevel();
        if (level != null && !level.isClientSide()) {
            if (chunkWatchers.isEmpty() || level.players().isEmpty()) {
                return;
            }
            ChunkWatchSettings settings = (ChunkWatchSettings)chunkWatchers.get(event.getChunk().getPos().toLong());
            if (settings != null) {
                Component message = settings.translate(direction);
                for (Player player : level.players()) {
                    player.sendSystemMessage(message);
                }
            }
        }
    }

    private static class WatchCommand {
        private WatchCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"watch").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_WATCH)).executes(ctx -> WatchCommand.watch((CommandContext<CommandSourceStack>)ctx, false, false))).then(((RequiredArgumentBuilder)Commands.argument((String)ChunkCommand.POS_PARAM, (ArgumentType)ColumnPosArgument.columnPos()).executes(ctx -> WatchCommand.watch((CommandContext<CommandSourceStack>)ctx, true, false))).then(Commands.argument((String)ChunkCommand.NAME_PARAM, (ArgumentType)StringArgumentType.word()).executes(ctx -> WatchCommand.watch((CommandContext<CommandSourceStack>)ctx, true, true))))).then(Commands.argument((String)ChunkCommand.NAME_PARAM, (ArgumentType)StringArgumentType.word()).executes(ctx -> WatchCommand.watch((CommandContext<CommandSourceStack>)ctx, false, true)));
        }

        private static int watch(CommandContext<CommandSourceStack> ctx, boolean positionFromArgument, boolean hasName) {
            ChunkPos chunkPos = positionFromArgument ? ColumnPosArgument.getColumnPos(ctx, (String)ChunkCommand.POS_PARAM).toChunkPos() : new ChunkPos(BlockPos.containing((Position)((CommandSourceStack)ctx.getSource()).getPosition()));
            String name = hasName ? StringArgumentType.getString(ctx, (String)ChunkCommand.NAME_PARAM) : null;
            ChunkWatchSettings settings = new ChunkWatchSettings(name, chunkPos);
            chunkWatchers.put(ChunkPos.asLong((int)chunkPos.x, (int)chunkPos.z), (Object)settings);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> settings.translate(WATCH), true);
            return 1;
        }
    }

    private static class UnwatchCommand {
        private UnwatchCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unwatch").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_UNWATCH)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                return UnwatchCommand.unwatch(source, new ChunkPos(BlockPos.containing((Position)source.getPosition())));
            })).then(Commands.argument((String)ChunkCommand.POS_PARAM, (ArgumentType)ColumnPosArgument.columnPos()).executes(ctx -> {
                ColumnPos column = ColumnPosArgument.getColumnPos((CommandContext)ctx, (String)ChunkCommand.POS_PARAM);
                return UnwatchCommand.unwatch((CommandSourceStack)ctx.getSource(), column.toChunkPos());
            }));
        }

        private static int unwatch(CommandSourceStack source, ChunkPos chunkPos) {
            ChunkWatchSettings settings = (ChunkWatchSettings)chunkWatchers.remove(ChunkPos.asLong((int)chunkPos.x, (int)chunkPos.z));
            if (settings == null) {
                source.sendFailure((Component)MekanismLang.COMMAND_ERROR_NOT_WATCHED.translate(MekanismLang.GENERIC_WITH_COMMA.translate(chunkPos.x, chunkPos.z)));
                return 0;
            }
            source.sendSuccess(() -> settings.translate(UNWATCH), true);
            return 1;
        }
    }

    private static class ClearCommand {
        private ClearCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"clear").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_CLEAR)).executes(ctx -> {
                int count = chunkWatchers.size();
                chunkWatchers.clear();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> MekanismLang.COMMAND_CHUNK_CLEAR.translateColored(EnumColor.GRAY, EnumColor.INDIGO, count), true);
                return 1;
            });
        }
    }

    private static class FlushCommand {
        private FlushCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"flush").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_FLUSH)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerChunkCache sp = source.getLevel().getChunkSource();
                int startCount = sp.getLoadedChunksCount();
                sp.tick(() -> true, false);
                source.sendSuccess(() -> MekanismLang.COMMAND_CHUNK_FLUSH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, startCount - sp.getLoadedChunksCount()), true);
                return 1;
            });
        }
    }

    private record LangData(ILangEntry unnamed, ILangEntry named) {
    }

    private record ChunkWatchSettings(Component name, Component position) {
        private ChunkWatchSettings(@Nullable String name, ChunkPos pos) {
            this((Component)(name == null ? CommonComponents.EMPTY : TextComponentUtil.getString(name)), (Component)MekanismLang.GENERIC_WITH_COMMA.translate(pos.x, pos.z));
        }

        public Component translate(LangData langData) {
            if (this.name == CommonComponents.EMPTY) {
                return langData.unnamed().translateColored(EnumColor.GRAY, EnumColor.INDIGO, this.position);
            }
            return langData.named().translateColored(EnumColor.GRAY, EnumColor.INDIGO, this.name, EnumColor.INDIGO, this.position);
        }

        public Component translateTicketLevel(int oldLevel, int newLevel) {
            if (this.name == CommonComponents.EMPTY) {
                return MekanismLang.COMMAND_CHUNK_TICKET_LEVEL_CHANGED.translateColored(EnumColor.GRAY, EnumColor.INDIGO, this.position, EnumColor.INDIGO, oldLevel, EnumColor.INDIGO, newLevel);
            }
            return MekanismLang.COMMAND_CHUNK_TICKET_LEVEL_CHANGED_NAMED.translateColored(EnumColor.GRAY, EnumColor.INDIGO, this.name, EnumColor.INDIGO, this.position, EnumColor.INDIGO, oldLevel, EnumColor.INDIGO, newLevel);
        }
    }
}

