/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MekanismStartupConfig
extends BaseMekanismConfig {
    private static final String ARMORED_SUBCATEGORY = "armored";
    private final ModConfigSpec configSpec;
    public final CachedIntValue armoredFreeRunnerArmor;
    public final CachedFloatValue armoredFreeRunnerToughness;
    public final CachedFloatValue armoredFreeRunnerKnockbackResistance;
    public final CachedIntValue armoredJetpackArmor;
    public final CachedFloatValue armoredJetpackToughness;
    public final CachedFloatValue armoredJetpackKnockbackResistance;
    public final CachedIntValue mekaSuitHelmetArmor;
    public final CachedIntValue mekaSuitBodyArmorArmor;
    public final CachedIntValue mekaSuitPantsArmor;
    public final CachedIntValue mekaSuitBootsArmor;
    public final CachedFloatValue mekaSuitToughness;
    public final CachedFloatValue mekaSuitKnockbackResistance;

    MekanismStartupConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        MekanismConfigTranslations.STARTUP_GEAR.applyToBuilder(builder).push("gear");
        MekanismConfigTranslations.STARTUP_FREE_RUNNERS_ARMORED.applyToBuilder(builder).push("armored_free_runner");
        this.armoredFreeRunnerArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.STARTUP_FREE_RUNNERS_ARMOR.applyToBuilder(builder).gameRestart().defineInRange("armor", 3, 0, Integer.MAX_VALUE));
        this.armoredFreeRunnerToughness = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.STARTUP_FREE_RUNNERS_TOUGHNESS.applyToBuilder(builder).gameRestart().defineInRange("toughness", 2.0, 0.0, 3.4028234663852886E38));
        this.armoredFreeRunnerKnockbackResistance = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.STARTUP_FREE_RUNNERS_KNOCKBACK_RESISTANCE.applyToBuilder(builder).gameRestart().defineInRange("knockbackResistance", 0.0, 0.0, 3.4028234663852886E38));
        builder.pop();
        MekanismConfigTranslations.STARTUP_JETPACK_ARMORED.applyToBuilder(builder).push("armored_jetpack");
        this.armoredJetpackArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.STARTUP_JETPACK_ARMOR.applyToBuilder(builder).gameRestart().defineInRange("armor", 8, 0, Integer.MAX_VALUE));
        this.armoredJetpackToughness = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.STARTUP_JETPACK_TOUGHNESS.applyToBuilder(builder).gameRestart().defineInRange("toughness", 2.0, 0.0, 3.4028234663852886E38));
        this.armoredJetpackKnockbackResistance = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.STARTUP_JETPACK_KNOCKBACK_RESISTANCE.applyToBuilder(builder).gameRestart().defineInRange("knockbackResistance", 0.0, 0.0, 3.4028234663852886E38));
        builder.pop();
        MekanismConfigTranslations.GEAR_MEKA_SUIT.applyToBuilder(builder).push("mekasuit");
        this.mekaSuitHelmetArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.STARTUP_MEKA_SUIT_ARMOR_HELMET.applyToBuilder(builder).gameRestart().defineInRange("helmetArmor", ((Integer)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).defense().get(ArmorItem.Type.HELMET)).intValue(), 0, Integer.MAX_VALUE));
        this.mekaSuitBodyArmorArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.STARTUP_MEKA_SUIT_ARMOR_CHESTPLATE.applyToBuilder(builder).gameRestart().defineInRange("bodyArmorArmor", ((Integer)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).defense().get(ArmorItem.Type.CHESTPLATE)).intValue(), 0, Integer.MAX_VALUE));
        this.mekaSuitPantsArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.STARTUP_MEKA_SUIT_ARMOR_LEGGINGS.applyToBuilder(builder).gameRestart().defineInRange("pantsArmor", ((Integer)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).defense().get(ArmorItem.Type.LEGGINGS)).intValue(), 0, Integer.MAX_VALUE));
        this.mekaSuitBootsArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.STARTUP_MEKA_SUIT_ARMOR_BOOTS.applyToBuilder(builder).gameRestart().defineInRange("bootsArmor", ((Integer)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).defense().get(ArmorItem.Type.BOOTS)).intValue(), 0, Integer.MAX_VALUE));
        this.mekaSuitToughness = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.STARTUP_MEKA_SUIT_TOUGHNESS.applyToBuilder(builder).gameRestart().defineInRange("toughness", (double)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).toughness(), 0.0, 3.4028234663852886E38));
        this.mekaSuitKnockbackResistance = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.STARTUP_MEKA_SUIT_KNOCKBACK_RESISTANCE.applyToBuilder(builder).gameRestart().defineInRange("knockbackResistance", (double)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).knockbackResistance(), 0.0, 3.4028234663852886E38));
        builder.pop();
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "startup";
    }

    @Override
    public String getTranslation() {
        return "Startup Config";
    }

    @Override
    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.STARTUP;
    }
}

