/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.matrix;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.tier.InductionProviderTier;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

@NothingNullByDefault
public class MatrixEnergyContainer
implements IEnergyContainer {
    private final Map<BlockPos, InductionProviderTier> providers = new Object2ObjectOpenHashMap();
    private final Map<BlockPos, IEnergyContainer> cells = new Object2ObjectOpenHashMap();
    private final Set<BlockPos> invalidPositions = new ObjectOpenHashSet();
    private long queuedOutput = 0L;
    private long queuedInput = 0L;
    private long lastOutput = 0L;
    private long lastInput = 0L;
    private long cachedTotal = 0L;
    private long transferCap = 0L;
    private long storageCap = 0L;
    private final MatrixMultiblockData multiblock;

    public MatrixEnergyContainer(MatrixMultiblockData multiblock) {
        this.multiblock = multiblock;
    }

    public void addCell(BlockPos pos, TileEntityInductionCell cell) {
        MachineEnergyContainer<TileEntityInductionCell> energyContainer = cell.getEnergyContainer();
        this.cells.put(pos, energyContainer);
        this.storageCap = MathUtils.addClamped(this.storageCap, energyContainer.getMaxEnergy());
        this.cachedTotal = MathUtils.addClamped(this.cachedTotal, energyContainer.getEnergy());
    }

    public void addProvider(BlockPos pos, TileEntityInductionProvider provider) {
        this.providers.put(pos, provider.tier);
        this.transferCap = MathUtils.addClamped(this.transferCap, provider.tier.getOutput());
    }

    public void removeInternal(BlockPos pos) {
        if (this.invalidPositions.add(pos)) {
            if (this.providers.containsKey(pos)) {
                this.transferCap -= this.providers.get(pos).getOutput();
            } else if (this.cells.containsKey(pos)) {
                IEnergyContainer cellContainer = this.cells.get(pos);
                this.storageCap += cellContainer.getMaxEnergy();
                this.cachedTotal -= cellContainer.getEnergy();
            }
        }
    }

    public void invalidate() {
        this.tick();
        this.cells.clear();
        this.providers.clear();
        this.queuedOutput = 0L;
        this.queuedInput = 0L;
        this.lastOutput = 0L;
        this.lastInput = 0L;
        this.cachedTotal = 0L;
        this.transferCap = 0L;
        this.storageCap = 0L;
    }

    public void tick() {
        if (!this.invalidPositions.isEmpty()) {
            for (BlockPos invalidPosition : this.invalidPositions) {
                this.cells.remove(invalidPosition);
                this.providers.remove(invalidPosition);
            }
            this.invalidPositions.clear();
        }
        if (this.queuedInput < this.queuedOutput) {
            this.removeEnergy(this.queuedOutput - this.queuedInput);
        } else if (this.queuedInput > this.queuedOutput) {
            this.addEnergy(this.queuedInput - this.queuedOutput);
        }
        this.lastInput = this.queuedInput;
        this.lastOutput = this.queuedOutput;
        this.queuedInput = 0L;
        this.queuedOutput = 0L;
    }

    private void addEnergy(long energy) {
        this.cachedTotal += energy;
        for (IEnergyContainer container : this.cells.values()) {
            long remainder = container.insert(energy, Action.EXECUTE, AutomationType.INTERNAL);
            if (remainder >= energy) continue;
            if (remainder == 0L) break;
            energy = remainder;
        }
    }

    private void removeEnergy(long energy) {
        IEnergyContainer container;
        long extracted;
        this.cachedTotal -= energy;
        Iterator<IEnergyContainer> iterator = this.cells.values().iterator();
        while (iterator.hasNext() && ((extracted = (container = iterator.next()).extract(energy, Action.EXECUTE, AutomationType.INTERNAL)) <= 0L || (energy -= extracted) != 0L)) {
        }
    }

    @Override
    public long getEnergy() {
        return this.cachedTotal + this.queuedInput - this.queuedOutput;
    }

    @Override
    public void setEnergy(long energy) {
        throw new RuntimeException("Unexpected call to setEnergy. The matrix energy container does not support directly setting the energy.");
    }

    @Override
    public long insert(long amount, Action action, AutomationType automationType) {
        if (amount <= 0L || !this.multiblock.isFormed()) {
            return amount;
        }
        long toAdd = Math.min(Math.min(amount, this.getRemainingInput()), this.getNeeded());
        if (toAdd == 0L) {
            return amount;
        }
        if (action.execute()) {
            this.queuedInput += toAdd;
        }
        return amount - toAdd;
    }

    @Override
    public long extract(long amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount <= 0L || !this.multiblock.isFormed()) {
            return 0L;
        }
        if ((amount = Math.min(Math.min(amount, this.getRemainingOutput()), this.getEnergy())) > 0L && action.execute()) {
            this.queuedOutput += amount;
        }
        return amount;
    }

    @Override
    public long getMaxEnergy() {
        return this.storageCap;
    }

    @Override
    public void onContentsChanged() {
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return new CompoundTag();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
    }

    private long getRemainingInput() {
        return this.transferCap - this.queuedInput;
    }

    private long getRemainingOutput() {
        return this.transferCap - this.queuedOutput;
    }

    public long getMaxTransfer() {
        return this.transferCap;
    }

    public long getLastInput() {
        return this.lastInput;
    }

    public long getLastOutput() {
        return this.lastOutput;
    }

    public int getCells() {
        return this.cells.size();
    }

    public int getProviders() {
        return this.providers.size();
    }
}

