/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import mekanism.common.integration.computer.BoundMethodHolder;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.computercraft.CCComputerHelper;
import org.jetbrains.annotations.NotNull;

public class CCMethodCaller
extends BoundMethodHolder {
    public String[] getMethodNames() {
        return (String[])this.methodNames.get();
    }

    public MethodResult callMethod(ILuaContext context, int methodIdx, IArguments arguments) throws LuaException {
        int argCount;
        String[] methodNames = this.getMethodNames();
        if (methodIdx >= methodNames.length) {
            throw new LuaException(String.format(Locale.ROOT, "Method index '%d' is out of bounds. This handler only has '%d' methods.", methodIdx, methodNames.length));
        }
        List methodDataCollection = this.methods.get((Object)methodNames[methodIdx]);
        BoundMethodHolder.BoundMethodData<?> methodToCall = CCMethodCaller.getBoundMethodData(methodDataCollection, argCount = arguments.count());
        if (methodToCall.threadSafe()) {
            return CCMethodCaller.callHandler(arguments, methodToCall);
        }
        arguments.escapes();
        return context.executeMainThreadTask(() -> CCMethodCaller.callHandler(arguments, methodToCall).getResult());
    }

    private static BoundMethodHolder.BoundMethodData<?> getBoundMethodData(Collection<BoundMethodHolder.BoundMethodData<?>> methodDataCollection, int argCount) throws LuaException {
        for (BoundMethodHolder.BoundMethodData<?> md : methodDataCollection) {
            if (md.argumentNames().length != argCount) continue;
            return md;
        }
        throw new LuaException(String.format(Locale.ROOT, "Found %d arguments, expected %s", argCount, methodDataCollection.stream().map(it -> String.valueOf(it.argumentNames().length)).collect(Collectors.joining(" or "))));
    }

    @NotNull
    private static MethodResult callHandler(IArguments arguments, BoundMethodHolder.BoundMethodData<?> methodToCall) throws LuaException {
        MethodResult mr;
        Object result;
        try {
            result = methodToCall.call(new CCComputerHelper(arguments));
        }
        catch (ComputerException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof LuaException) {
                LuaException luaException = (LuaException)throwable;
                throw luaException;
            }
            throw (LuaException)new LuaException(ex.getMessage()).initCause((Throwable)ex);
        }
        return result instanceof MethodResult ? (mr = (MethodResult)result) : MethodResult.of((Object)result);
    }
}

