/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.robit;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import mekanism.api.MekanismAPI;
import mekanism.api.robit.RobitSkin;
import mekanism.common.entity.EntityRobit;
import mekanism.common.registries.MekanismRobitSkins;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=EntityRobit.class, zenCodeName="mods.mekanism.api.entity.robit.Robit")
public class ExpandEntityRobit {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="skin")
    public static RobitSkin getSkin(EntityRobit internal) {
        return MekanismRobitSkins.lookup(internal.level().registryAccess(), internal.getSkin()).skin();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="skinName")
    public static ResourceLocation getSkinName(EntityRobit internal) {
        return MekanismRobitSkins.lookup(internal.level().registryAccess(), internal.getSkin()).location();
    }

    @ZenCodeType.Method
    public static boolean setSkin(EntityRobit internal, RobitSkin skin, @ZenCodeType.Nullable Player player) {
        ResourceKey<Registry<RobitSkin>> registryName = MekanismAPI.ROBIT_SKIN_REGISTRY_NAME;
        ResourceLocation skinName = internal.level().registryAccess().registryOrThrow(registryName).getKeyOrNull((Object)skin);
        if (skinName == null) {
            throw new IllegalArgumentException("Unregistered robit skin");
        }
        return internal.setSkin((ResourceKey<RobitSkin>)ResourceKey.create(registryName, (ResourceLocation)skinName), player);
    }

    @ZenCodeType.Method
    public static boolean setSkin(EntityRobit internal, ResourceLocation skin, @ZenCodeType.Nullable Player player) {
        ResourceKey<Registry<RobitSkin>> registryName = MekanismAPI.ROBIT_SKIN_REGISTRY_NAME;
        ResourceKey skinKey = ResourceKey.create(registryName, (ResourceLocation)skin);
        if (!internal.level().registryAccess().registryOrThrow(registryName).containsKey(skinKey)) {
            throw new IllegalArgumentException("Unknown robit skin with name: " + String.valueOf(skin));
        }
        return internal.setSkin((ResourceKey<RobitSkin>)skinKey, player);
    }
}

