/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.fluxnetworks;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.MultiTypeCapability;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.energy.IEnergyCompat;
import mekanism.common.integration.energy.fluxnetworks.FNCapability;
import mekanism.common.integration.energy.fluxnetworks.FNIntegration;
import mekanism.common.integration.energy.fluxnetworks.FNStrictEnergyHandler;
import mekanism.common.util.UnitDisplayUtils;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

@NothingNullByDefault
public class FNEnergyCompat
implements IEnergyCompat {
    public MultiTypeCapability<IFNEnergyStorage> getCapability() {
        return FNCapability.ENERGY;
    }

    @Override
    public boolean isUsable() {
        return this.capabilityExists() && this.isConfigEnabled();
    }

    private boolean isConfigEnabled() {
        return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.isEnabled() && !MekanismConfig.general.blacklistFluxNetworks.getOrDefault();
    }

    @Override
    public boolean capabilityExists() {
        return Mekanism.hooks.fluxNetworks.isLoaded();
    }

    @Override
    public <OBJECT, CONTEXT> ICapabilityProvider<OBJECT, CONTEXT, ?> getProviderAs(ICapabilityProvider<OBJECT, CONTEXT, IStrictEnergyHandler> provider) {
        return (obj, ctx) -> {
            IStrictEnergyHandler handler = (IStrictEnergyHandler)provider.getCapability(obj, ctx);
            return handler != null && this.isConfigEnabled() ? this.wrapStrictEnergyHandler(handler) : null;
        };
    }

    @Override
    public Object wrapStrictEnergyHandler(IStrictEnergyHandler handler) {
        return new FNIntegration(handler);
    }

    @Override
    public IStrictEnergyHandler wrapAsStrictEnergyHandler(Object handler) {
        return new FNStrictEnergyHandler((IFNEnergyStorage)handler);
    }
}

