/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.fluxnetworks;

import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.util.UnitDisplayUtils;
import org.jetbrains.annotations.NotNull;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

@NothingNullByDefault
public class FNStrictEnergyHandler
implements IStrictEnergyHandler {
    private final IFNEnergyStorage storage;

    public FNStrictEnergyHandler(IFNEnergyStorage storage) {
        this.storage = storage;
    }

    @Override
    public int getEnergyContainerCount() {
        return 1;
    }

    @Override
    public long getEnergy(int container) {
        return container == 0 ? UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(this.storage.getEnergyStoredL()) : 0L;
    }

    @Override
    public void setEnergy(int container, long energy) {
    }

    @Override
    public long getMaxEnergy(int container) {
        return container == 0 ? UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(this.storage.getMaxEnergyStoredL()) : 0L;
    }

    @Override
    public long getNeededEnergy(int container) {
        return container == 0 ? UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(Math.max(0L, this.storage.getMaxEnergyStoredL() - this.storage.getEnergyStoredL())) : 0L;
    }

    @Override
    public long insertEnergy(int container, long amount, @NotNull Action action) {
        return container == 0 ? this.insertEnergy(amount, action) : amount;
    }

    @Override
    public long insertEnergy(long amount, Action action) {
        if (this.storage.canReceive() && amount > 0L) {
            long inserted;
            long toInsert = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(amount);
            if (toInsert == 0L) {
                return amount;
            }
            if (!UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.isOneToOne()) {
                long simulatedInserted = this.storage.receiveEnergyL(toInsert, true);
                if (simulatedInserted == 0L) {
                    return amount;
                }
                toInsert = this.convertFromAndBack(simulatedInserted);
                if (toInsert == 0L) {
                    return amount;
                }
            }
            if ((inserted = this.storage.receiveEnergyL(toInsert, action.simulate())) > 0L) {
                return amount - UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(inserted);
            }
        }
        return amount;
    }

    private long convertFromAndBack(long fe) {
        long joules = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(fe);
        long result = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(joules);
        double conversion = 1.0 / UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.getConversion();
        if (conversion >= 1.0 && (double)result % conversion > 0.0) {
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(joules - 1L);
        }
        return result;
    }

    @Override
    public long extractEnergy(int container, long amount, @NotNull Action action) {
        return container == 0 ? this.extractEnergy(amount, action) : 0L;
    }

    @Override
    public long extractEnergy(long amount, Action action) {
        if (this.storage.canExtract() && amount > 0L) {
            long simulatedExtracted;
            long toExtract = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(amount);
            if (toExtract == 0L) {
                return 0L;
            }
            if (!UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.isOneToOne() && (toExtract = this.convertFromAndBack(simulatedExtracted = this.storage.extractEnergyL(toExtract, true))) == 0L) {
                return 0L;
            }
            long extracted = this.storage.extractEnergyL(toExtract, action.simulate());
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(extracted);
        }
        return 0L;
    }
}

