/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.framedblocks;

import mekanism.common.Mekanism;
import mekanism.common.integration.framedblocks.ChemicalCamoClientHandler;
import mekanism.common.integration.framedblocks.ChemicalCamoContainerFactory;
import mekanism.common.integration.framedblocks.ChemicalModel;
import mekanism.common.integration.framedblocks.ChemicalParticleOptions;
import mekanism.common.integration.framedblocks.ChemicalSpriteParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.util.FramedConstants;

public final class FramedBlocksIntegration {
    private static final DeferredRegister<CamoContainerFactory<?>> CAMO_FACTORIES = DeferredRegister.create((ResourceKey)FramedConstants.CAMO_CONTAINER_FACTORY_REGISTRY_KEY, (String)"mekanism");
    private static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"mekanism");
    static final DeferredHolder<CamoContainerFactory<?>, ChemicalCamoContainerFactory> CHEMICAL_FACTORY = CAMO_FACTORIES.register("chemical", ChemicalCamoContainerFactory::new);
    static final DeferredHolder<ParticleType<?>, ChemicalParticleOptions.Type> CHEMICAL_PARTICLE = PARTICLE_TYPES.register("chemical", ChemicalParticleOptions.Type::new);

    public static void init(IEventBus modBus) {
        CAMO_FACTORIES.register(modBus);
        PARTICLE_TYPES.register(modBus);
        if (FMLEnvironment.dist.isClient()) {
            ClientEvents.init(modBus);
        }
    }

    static final class ClientEvents {
        ClientEvents() {
        }

        static void init(IEventBus modBus) {
            modBus.addListener(ClientEvents::onRegisterAdditionalModels);
            modBus.addListener(ClientEvents::onModelLoadingCompleted);
            modBus.addListener(ClientEvents::onRegisterParticleProviders);
        }

        private static void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
            event.register(ChemicalModel.BARE_MODEL);
        }

        private static void onModelLoadingCompleted(ModelEvent.BakingCompleted event) {
            ChemicalCamoClientHandler.clearModelCache();
        }

        private static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpecial((ParticleType)CHEMICAL_PARTICLE.get(), (ParticleProvider)new ChemicalSpriteParticle.Provider());
        }
    }

    public static final class Constants {
        public static final int CHEMICAL_AMOUNT = 1000;
        public static final ResourceLocation CHEMICAL_DUMMY_MODEL = Mekanism.rl("chemical/dummy");
    }
}

