/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.basic.BasicElectrolysisRecipe;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.integration.projecte.NSSChemical;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;

@RecipeTypeMapper
public class ElectrolysisRecipeMapper
extends TypedMekanismRecipeMapper<ElectrolysisRecipe> {
    public ElectrolysisRecipeMapper() {
        super(MekanismConfigTranslations.PE_MAPPER_ELECTROLYSIS, ElectrolysisRecipe.class, MekanismRecipeType.SEPARATING);
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, ElectrolysisRecipe recipe, TypedMekanismRecipeMapper.MekFakeGroupHelper fakeGroupHelper) {
        if (recipe instanceof BasicElectrolysisRecipe) {
            BasicElectrolysisRecipe basicRecipe = (BasicElectrolysisRecipe)recipe;
            ChemicalStack leftOutput = basicRecipe.getLeftChemicalOutput();
            ChemicalStack rightOutput = basicRecipe.getRightChemicalOutput();
            if (leftOutput.isEmpty() || rightOutput.isEmpty()) {
                return false;
            }
            return ElectrolysisRecipeMapper.addConversions(mapper, new ElectrolysisRecipe.ElectrolysisRecipeOutput(leftOutput, rightOutput), fakeGroupHelper.forIngredient(recipe.getInput()));
        }
        return ElectrolysisRecipeMapper.addConversions(mapper, recipe.getInput(), recipe::getOutput, output -> output.left().isEmpty() || output.right().isEmpty(), fakeGroupHelper::forFluids, null, ElectrolysisRecipeMapper::addConversions);
    }

    private static boolean addConversions(IMappingCollector<NormalizedSimpleStack, Long> mapper, ElectrolysisRecipe.ElectrolysisRecipeOutput output, Object2IntMap<NormalizedSimpleStack> inputs) {
        ChemicalStack leftOutput = output.left();
        ChemicalStack rightOutput = output.right();
        if (inputs.isEmpty() || leftOutput.getAmount() > Integer.MAX_VALUE || rightOutput.getAmount() > Integer.MAX_VALUE) {
            return false;
        }
        return ElectrolysisRecipeMapper.addConversion(mapper, leftOutput, ElectrolysisRecipeMapper.forIngredients(inputs, (NormalizedSimpleStack)NSSChemical.createChemical(rightOutput), (int)(-rightOutput.getAmount()))) | ElectrolysisRecipeMapper.addConversion(mapper, rightOutput, ElectrolysisRecipeMapper.forIngredients(inputs, (NormalizedSimpleStack)NSSChemical.createChemical(leftOutput), (int)(-leftOutput.getAmount())));
    }
}

