/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOCraftingTransferHelper;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.SearchQueryParser;
import mekanism.common.inventory.GuiComponents;
import mekanism.common.inventory.ISlotClickHandler;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.InsertableSlot;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.VirtualCraftingOutputSlot;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.qio.BulkQIOData;
import mekanism.common.network.to_server.qio.PacketQIOItemViewerSlotPlace;
import mekanism.common.network.to_server.qio.PacketQIOItemViewerSlotShiftTake;
import mekanism.common.network.to_server.qio.PacketQIOItemViewerSlotTake;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class QIOItemViewerContainer
extends MekanismContainer
implements ISlotClickHandler {
    public static final int SLOTS_X_MIN = 8;
    public static final int SLOTS_X_MAX = 16;
    public static final int SLOTS_Y_MIN = 2;
    public static final int SLOTS_Y_MAX = 48;
    public static final int SLOTS_START_Y = 43;
    private static final int DOUBLE_CLICK_TRANSFER_DURATION = 20;
    private final Map<UUID, ItemSlotData> cachedInventory;
    protected final IQIOCraftingWindowHolder craftingWindowHolder;
    private final List<ISlotClickHandler.IScrollableSlot> searchList;
    private final List<ISlotClickHandler.IScrollableSlot> itemList;
    private long cachedCountCapacity;
    private int cachedTypeCapacity;
    private long totalItems;
    private ListSortType sortType;
    private SortDirection sortDirection;
    private String rawSearchQuery;
    private SearchQueryParser.ISearchQuery searchQuery;
    private int doubleClickTransferTicks = 0;
    private int lastSlot = -1;
    private ItemStack lastStack = ItemStack.EMPTY;
    private List<InventoryContainerSlot>[] craftingGridInputSlots;
    private final VirtualInventoryContainerSlot[][] craftingSlots = new VirtualInventoryContainerSlot[3][10];
    private boolean sortingPaused;
    private SortingNeeded sortingNeeded;
    private final Set<UUID> queuedForRemoval;

    public static int getSlotsYMax() {
        int maxY = Mth.ceil((double)((double)Minecraft.getInstance().getWindow().getGuiScaledHeight() * 0.05 - 8.0)) + 1;
        return Mth.clamp((int)maxY, (int)2, (int)48);
    }

    protected QIOItemViewerContainer(ContainerTypeRegistryObject<?> type, int id, Inventory inv, boolean remote, IQIOCraftingWindowHolder craftingWindowHolder, BulkQIOData itemData, CachedSearchData searchData, CachedSortingData sortingData, @Nullable SelectedWindowData selectedWindow) {
        super(type, id, inv);
        this.craftingWindowHolder = craftingWindowHolder;
        this.cachedCountCapacity = itemData.countCapacity();
        this.cachedTypeCapacity = itemData.typeCapacity();
        this.cachedInventory = itemData.inventory();
        this.totalItems = itemData.totalItems();
        this.itemList = itemData.items();
        this.searchList = searchData.cachedList();
        this.rawSearchQuery = searchData.rawQuery();
        this.searchQuery = searchData.query();
        this.sortType = sortingData.sortType();
        this.sortDirection = sortingData.sortDirection();
        this.sortingNeeded = sortingData.sortingNeeded();
        this.selectedWindow = selectedWindow;
        HashSet hashSet = this.queuedForRemoval = remote ? new HashSet() : Collections.emptySet();
        if (this.craftingWindowHolder == null) {
            Mekanism.logger.error("Error getting crafting window holder, closing.");
            this.closeInventory(inv.player);
            return;
        }
        if (remote) {
            int maxY = QIOItemViewerContainer.getSlotsYMax();
            if (MekanismConfig.client.qioItemViewerSlotsY.get() > maxY) {
                MekanismConfig.client.qioItemViewerSlotsY.set(maxY);
                MekanismConfig.client.save();
            }
            this.updateSort();
            if (sortingData.rebuildSearch()) {
                this.updateSearch(this.getLevel(), this.rawSearchQuery, false);
            }
        } else {
            this.craftingGridInputSlots = new List[3];
        }
    }

    @Nullable
    public QIOFrequency getFrequency() {
        return this.craftingWindowHolder.getFrequency();
    }

    public abstract boolean shiftClickIntoFrequency();

    public abstract void toggleTargetDirection();

    public QIOItemViewerContainer recreate() {
        boolean wasPaused = this.sortingPaused;
        this.pauseSorting(false);
        QIOItemViewerContainer container = this.recreateUnchecked();
        container.pauseSorting(wasPaused);
        return container;
    }

    protected abstract QIOItemViewerContainer recreateUnchecked();

    @Override
    protected int getInventoryYOffset() {
        return 43 + MekanismConfig.client.qioItemViewerSlotsY.getOrDefault() * 18 + 15;
    }

    @Override
    protected int getInventoryXOffset() {
        return super.getInventoryXOffset() + (MekanismConfig.client.qioItemViewerSlotsX.getOrDefault() - 8) * 18 / 2;
    }

    @Override
    protected void addSlots() {
        super.addSlots();
        for (QIOCraftingWindow craftingWindow : this.craftingWindowHolder.getCraftingWindows()) {
            byte tableIndex = craftingWindow.getWindowIndex();
            for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
                this.addCraftingSlot(craftingWindow.getInputSlot(slotIndex), tableIndex, slotIndex);
            }
            this.addCraftingSlot(craftingWindow.getOutputSlot(), tableIndex, 9);
        }
    }

    private void addCraftingSlot(IInventorySlot slot, byte tableIndex, int slotIndex) {
        VirtualInventoryContainerSlot containerSlot;
        this.craftingSlots[tableIndex][slotIndex] = containerSlot = (VirtualInventoryContainerSlot)slot.createContainerSlot();
        this.addSlot(containerSlot);
    }

    public VirtualInventoryContainerSlot getCraftingWindowSlot(byte tableIndex, int slotIndex) {
        return this.craftingSlots[tableIndex][slotIndex];
    }

    @Override
    protected void openInventory(@NotNull Inventory inv) {
        QIOFrequency freq;
        super.openInventory(inv);
        if (!this.getLevel().isClientSide() && (freq = this.getFrequency()) != null) {
            freq.openItemViewer((ServerPlayer)inv.player);
        }
    }

    @Override
    protected void closeInventory(@NotNull Player player) {
        QIOFrequency freq;
        super.closeInventory(player);
        if (!player.level().isClientSide() && (freq = this.getFrequency()) != null) {
            freq.closeItemViewer((ServerPlayer)player);
        }
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.doubleClickTransferTicks > 0) {
            --this.doubleClickTransferTicks;
        } else {
            this.resetTransferTracker();
        }
    }

    private void resetTransferTracker() {
        this.doubleClickTransferTicks = 0;
        this.lastSlot = -1;
        this.lastStack = ItemStack.EMPTY;
    }

    private void setTransferTracker(ItemStack stack, int slot) {
        this.doubleClickTransferTicks = 20;
        this.lastSlot = slot;
        this.lastStack = stack;
    }

    private void doDoubleClickTransfer(Player player) {
        QIOFrequency freq = this.getFrequency();
        if (freq != null) {
            for (InsertableSlot slot : this.mainInventorySlots) {
                this.handleDoDoubleClickTransfer(player, slot, freq);
            }
            for (InsertableSlot slot : this.hotBarSlots) {
                this.handleDoDoubleClickTransfer(player, slot, freq);
            }
        }
    }

    private void handleDoDoubleClickTransfer(Player player, InsertableSlot slot, QIOFrequency freq) {
        ItemStack slotItem;
        if (slot.hasItem() && slot.mayPickup(player) && InventoryUtils.areItemsStackable(this.lastStack, slotItem = slot.getItem())) {
            this.transferSuccess(slot, player, slotItem, freq.addItem(slotItem));
        }
    }

    private List<InventoryContainerSlot> getCraftingGridSlots(byte selectedCraftingGrid) {
        List<InventoryContainerSlot> craftingGridSlots = this.craftingGridInputSlots[selectedCraftingGrid];
        if (craftingGridSlots == null) {
            craftingGridSlots = new ArrayList<InventoryContainerSlot>();
            for (int i = 0; i < 9; ++i) {
                craftingGridSlots.add(this.getCraftingWindowSlot(selectedCraftingGrid, i));
            }
            this.craftingGridInputSlots[selectedCraftingGrid] = craftingGridSlots;
        }
        return craftingGridSlots;
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotID) {
        Slot currentSlot;
        Slot slot = currentSlot = (Slot)this.slots.get(slotID);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VirtualCraftingOutputSlot.class, InventoryContainerSlot.class}, (Object)slot, n)) {
            case -1: {
                return ItemStack.EMPTY;
            }
            case 0: {
                VirtualCraftingOutputSlot virtualSlot = (VirtualCraftingOutputSlot)slot;
                return virtualSlot.shiftClickSlot(player, this.hotBarSlots, this.mainInventorySlots);
            }
            case 1: {
                InventoryContainerSlot inventoryContainerSlot = (InventoryContainerSlot)slot;
                return super.quickMoveStack(player, slotID);
            }
        }
        if (!player.level().isClientSide()) {
            Optional<ItemStack> windowHandling;
            ItemStack slotStack = currentSlot.getItem();
            if (!this.shiftClickIntoFrequency() && (windowHandling = this.tryTransferToWindow(player, currentSlot, slotStack)).isPresent()) {
                return windowHandling.get();
            }
            QIOFrequency frequency = this.getFrequency();
            if (frequency != null) {
                if (!slotStack.isEmpty()) {
                    ItemStack ret = frequency.addItem(slotStack);
                    if (slotStack.getCount() != ret.getCount()) {
                        this.setTransferTracker(slotStack.copy(), slotID);
                        return this.transferSuccess(currentSlot, player, slotStack, ret);
                    }
                } else {
                    if (slotID == this.lastSlot && !this.lastStack.isEmpty()) {
                        this.doDoubleClickTransfer(player);
                    }
                    this.resetTransferTracker();
                    return ItemStack.EMPTY;
                }
            }
            if (this.shiftClickIntoFrequency()) {
                return this.tryTransferToWindow(player, currentSlot, slotStack).orElse(ItemStack.EMPTY);
            }
        }
        return ItemStack.EMPTY;
    }

    private Optional<ItemStack> tryTransferToWindow(Player player, Slot currentSlot, ItemStack slotStack) {
        QIOCraftingWindow craftingWindow;
        byte selectedCraftingGrid = this.getSelectedCraftingGrid(player.getUUID());
        if (selectedCraftingGrid != -1 && !(craftingWindow = this.getCraftingWindow(selectedCraftingGrid)).isOutput(slotStack)) {
            SelectedWindowData windowData;
            ItemStack stackToInsert = slotStack;
            List<InventoryContainerSlot> craftingGridSlots = this.getCraftingGridSlots(selectedCraftingGrid);
            stackToInsert = QIOItemViewerContainer.insertItem(craftingGridSlots, stackToInsert, windowData = craftingWindow.getWindowData());
            if (stackToInsert.getCount() != slotStack.getCount()) {
                return Optional.of(this.transferSuccess(currentSlot, player, slotStack, stackToInsert));
            }
        }
        return Optional.empty();
    }

    public void handleUpdate(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        this.cachedCountCapacity = countCapacity;
        this.cachedTypeCapacity = typeCapacity;
        if (itemMap.isEmpty()) {
            return;
        }
        ObjectIterator iterator = Object2LongMaps.fastIterator(itemMap);
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            HashedItem.UUIDAwareHashedItem itemKey = (HashedItem.UUIDAwareHashedItem)entry.getKey();
            UUID itemUUID = itemKey.getUUID();
            long value = entry.getLongValue();
            if (value == 0L) {
                ItemSlotData oldData;
                if (this.sortingPaused) {
                    oldData = this.cachedInventory.get(itemUUID);
                    if (oldData == null) continue;
                    this.totalItems -= oldData.count();
                    oldData.count = 0L;
                    this.queuedForRemoval.add(itemUUID);
                    continue;
                }
                oldData = this.removeItemBasic(itemUUID);
                if (oldData == null) continue;
                this.totalItems -= oldData.count();
                continue;
            }
            ItemSlotData slotData = this.cachedInventory.get(itemUUID);
            if (slotData == null) {
                this.totalItems += value;
                slotData = new ItemSlotData(itemKey, value);
                this.itemList.add(slotData);
                this.cachedInventory.put(itemUUID, slotData);
                this.sortingNeeded = this.sortingNeeded.concat(SortingNeeded.ITEMS_ONLY);
                if (!this.searchQuery.test(this.getLevel(), this.inv.player, slotData.getInternalStack())) continue;
                this.searchList.add(slotData);
                this.sortingNeeded = this.sortingNeeded.concat(SortingNeeded.SEARCH_ONLY);
                continue;
            }
            this.totalItems += value - slotData.count();
            slotData.count = value;
            if (!this.sortType.usesCount()) continue;
            this.sortingNeeded = this.sortingNeeded.concat(SortingNeeded.ITEMS_ONLY);
            if (!this.searchQuery.test(this.getLevel(), this.inv.player, slotData.getInternalStack())) continue;
            this.sortingNeeded = this.sortingNeeded.concat(SortingNeeded.SEARCH_ONLY);
        }
        if (!this.sortingPaused) {
            this.updateSort();
        }
    }

    @Nullable
    private ItemSlotData removeItemBasic(UUID itemUUID) {
        ItemSlotData oldData = this.cachedInventory.remove(itemUUID);
        if (oldData != null) {
            this.itemList.remove(oldData);
            if (this.searchQuery.test(this.getLevel(), this.inv.player, oldData.getInternalStack())) {
                this.searchList.remove(oldData);
            }
        }
        return oldData;
    }

    public void pauseSorting(boolean pause) {
        if (this.sortingPaused != pause) {
            this.sortingPaused = pause;
            if (!this.sortingPaused) {
                for (UUID toRemove : this.queuedForRemoval) {
                    ItemSlotData slotData = this.cachedInventory.get(toRemove);
                    if (slotData == null || slotData.count() != 0L) continue;
                    this.removeItemBasic(toRemove);
                }
                this.queuedForRemoval.clear();
                this.updateSort();
            }
        }
    }

    public void handleKill() {
        this.cachedInventory.clear();
        this.searchList.clear();
        this.itemList.clear();
        this.rawSearchQuery = "";
        this.searchQuery = SearchQueryParser.ISearchQuery.INVALID;
        this.sortingPaused = false;
        this.sortingNeeded = SortingNeeded.NONE;
        this.queuedForRemoval.clear();
    }

    public QIOCraftingTransferHelper getTransferHelper(Player player, QIOCraftingWindow craftingWindow) {
        return new QIOCraftingTransferHelper(this.cachedInventory.values(), this.hotBarSlots, this.mainInventorySlots, craftingWindow, player);
    }

    public void setSortDirection(SortDirection sortDirection) {
        if (this.sortDirection != sortDirection) {
            this.sortDirection = sortDirection;
            MekanismConfig.client.qioItemViewerSortDirection.set(sortDirection);
            this.applySortingOptionChange();
        }
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public void setSortType(ListSortType sortType) {
        if (this.sortType != sortType) {
            this.sortType = sortType;
            MekanismConfig.client.qioItemViewerSortType.set(sortType);
            this.applySortingOptionChange();
        }
    }

    private void applySortingOptionChange() {
        MekanismConfig.client.save();
        this.sortingNeeded = SortingNeeded.ALL;
        this.updateSort();
    }

    public ListSortType getSortType() {
        return this.sortType;
    }

    @NotNull
    public List<ISlotClickHandler.IScrollableSlot> getQIOItemList() {
        return this.searchQuery.isInvalid() ? this.itemList : this.searchList;
    }

    public long getCountCapacity() {
        return this.cachedCountCapacity;
    }

    public int getTypeCapacity() {
        return this.cachedTypeCapacity;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public int getTotalTypes() {
        return this.itemList.size();
    }

    public byte getSelectedCraftingGrid() {
        return this.getSelectedCraftingGrid(this.getSelectedWindow());
    }

    public byte getSelectedCraftingGrid(UUID player) {
        return this.getSelectedCraftingGrid(this.getSelectedWindow(player));
    }

    private byte getSelectedCraftingGrid(@Nullable SelectedWindowData selectedWindow) {
        if (selectedWindow != null && selectedWindow.type == SelectedWindowData.WindowType.CRAFTING) {
            return selectedWindow.extraData;
        }
        return -1;
    }

    public QIOCraftingWindow getCraftingWindow(int selectedCraftingGrid) {
        if (selectedCraftingGrid < 0 || selectedCraftingGrid >= 3) {
            throw new IllegalArgumentException("Selected crafting grid not in range.");
        }
        return this.craftingWindowHolder.getCraftingWindows()[selectedCraftingGrid];
    }

    public ItemStack insertIntoPlayerInventory(UUID player, ItemStack stack) {
        SelectedWindowData selectedWindow = this.getSelectedWindow(player);
        stack = QIOItemViewerContainer.insertItem(this.hotBarSlots, stack, true, selectedWindow);
        stack = QIOItemViewerContainer.insertItem(this.mainInventorySlots, stack, true, selectedWindow);
        stack = QIOItemViewerContainer.insertItem(this.hotBarSlots, stack, false, selectedWindow);
        stack = QIOItemViewerContainer.insertItem(this.mainInventorySlots, stack, false, selectedWindow);
        return stack;
    }

    public ItemStack simulateInsertIntoPlayerInventory(UUID player, ItemStack stack) {
        SelectedWindowData selectedWindow = this.getSelectedWindow(player);
        stack = QIOItemViewerContainer.insertItemCheckAll(this.hotBarSlots, stack, selectedWindow, Action.SIMULATE);
        stack = QIOItemViewerContainer.insertItemCheckAll(this.mainInventorySlots, stack, selectedWindow, Action.SIMULATE);
        return stack;
    }

    private void updateSort() {
        if (this.sortingNeeded.sortItemList()) {
            this.sortType.sort(this.itemList, this.sortDirection);
        }
        if (this.sortingNeeded.sortSearchList()) {
            this.sortType.sort(this.searchList, this.sortDirection);
        }
        this.sortingNeeded = SortingNeeded.NONE;
    }

    public void updateSearch(@Nullable Level level, String queryText, boolean skipSameQuery) {
        if (level == null || !level.isClientSide()) {
            return;
        }
        queryText = queryText.trim().toLowerCase(Locale.ROOT);
        if (skipSameQuery && this.rawSearchQuery.equals(queryText)) {
            return;
        }
        this.rawSearchQuery = queryText;
        this.searchQuery = SearchQueryParser.parse(this.rawSearchQuery);
        if (this.sortingPaused) {
            if (this.sortingNeeded.sortSearchList()) {
                this.sortingNeeded = this.sortingNeeded.sortItemList() ? SortingNeeded.ITEMS_ONLY : SortingNeeded.NONE;
            }
            this.pauseSorting(false);
            this.pauseSorting(true);
        }
        this.searchList.clear();
        if (!this.searchQuery.isInvalid()) {
            for (ISlotClickHandler.IScrollableSlot slot : this.itemList) {
                if (!this.searchQuery.test(level, this.inv.player, slot.getInternalStack())) continue;
                this.searchList.add(slot);
            }
        }
    }

    protected BulkQIOData asBulkData() {
        return new BulkQIOData(this.cachedInventory, this.getCountCapacity(), this.getTypeCapacity(), this.getTotalItems(), this.itemList);
    }

    protected CachedSearchData asCachedSearchData() {
        return new CachedSearchData(this.searchQuery, this.rawSearchQuery, this.searchList);
    }

    protected CachedSortingData currentSortingData() {
        return new CachedSortingData(this.sortType, this.sortDirection);
    }

    @Override
    public void onClick(Supplier<@Nullable ISlotClickHandler.IScrollableSlot> slotProvider, int button, boolean hasShiftDown, ItemStack heldItem) {
        if (hasShiftDown) {
            ISlotClickHandler.IScrollableSlot slot = slotProvider.get();
            if (slot != null) {
                PacketUtils.sendToServer(new PacketQIOItemViewerSlotShiftTake(slot.itemUUID()));
            }
        } else if (button == 0 || button == 1 || button == 2) {
            ISlotClickHandler.IScrollableSlot slot;
            if (heldItem.isEmpty()) {
                ISlotClickHandler.IScrollableSlot slot2 = slotProvider.get();
                if (slot2 != null && slot2.count() > 0L) {
                    int maxStackSize = Math.min(MathUtils.clampToInt(slot2.count()), slot2.item().getMaxStackSize());
                    int toTake = button == 0 ? maxStackSize : (button == 2 ? 1 : Math.max(1, maxStackSize / 2));
                    PacketUtils.sendToServer(new PacketQIOItemViewerSlotTake(slot2.itemUUID(), toTake));
                }
            } else if (button == 2 && (slot = slotProvider.get()) != null && InventoryUtils.areItemsStackable(heldItem, slot.getInternalStack())) {
                PacketUtils.sendToServer(new PacketQIOItemViewerSlotTake(slot.itemUUID(), 1));
            } else {
                int toAdd = button == 0 ? heldItem.getCount() : 1;
                PacketUtils.sendToServer(new PacketQIOItemViewerSlotPlace(toAdd));
            }
        }
    }

    public record CachedSearchData(SearchQueryParser.ISearchQuery query, String rawQuery, List<ISlotClickHandler.IScrollableSlot> cachedList) {
        public static final CachedSearchData INITIAL_SERVER = new CachedSearchData(SearchQueryParser.ISearchQuery.INVALID, "", Collections.emptyList());

        public static CachedSearchData initialClient() {
            return new CachedSearchData(SearchQueryParser.ISearchQuery.INVALID, "", (List<ISlotClickHandler.IScrollableSlot>)new ReferenceArrayList());
        }
    }

    public record CachedSortingData(ListSortType sortType, SortDirection sortDirection, SortingNeeded sortingNeeded, boolean rebuildSearch) {
        public static final CachedSortingData SERVER = new CachedSortingData(ListSortType.NAME, SortDirection.ASCENDING);

        public CachedSortingData(ListSortType sortType, SortDirection sortDirection) {
            this(sortType, sortDirection, SortingNeeded.NONE, false);
        }

        public CachedSortingData {
            if (rebuildSearch && sortingNeeded.sortSearchList()) {
                sortingNeeded = sortingNeeded.sortItemList() ? SortingNeeded.ITEMS_ONLY : SortingNeeded.NONE;
            }
        }

        public static CachedSortingData currentClient() {
            return new CachedSortingData((ListSortType)MekanismConfig.client.qioItemViewerSortType.get(), (SortDirection)MekanismConfig.client.qioItemViewerSortDirection.get(), SortingNeeded.ITEMS_ONLY, false);
        }
    }

    public static enum ListSortType implements GuiComponents.IDropdownEnum<ListSortType>,
    TranslatableEnum
    {
        NAME(MekanismLang.LIST_SORT_NAME, MekanismLang.LIST_SORT_NAME_DESC, false, Comparator.comparing(ISlotClickHandler.IScrollableSlot::getDisplayName)),
        SIZE(MekanismLang.LIST_SORT_COUNT, MekanismLang.LIST_SORT_COUNT_DESC, true, Comparator.comparingLong(ISlotClickHandler.IScrollableSlot::count).thenComparing(ISlotClickHandler.IScrollableSlot::getDisplayName), Comparator.comparingLong(ISlotClickHandler.IScrollableSlot::count).reversed().thenComparing(ISlotClickHandler.IScrollableSlot::getDisplayName)),
        MOD(MekanismLang.LIST_SORT_MOD, MekanismLang.LIST_SORT_MOD_DESC, false, Comparator.comparing(ISlotClickHandler.IScrollableSlot::getModID).thenComparing(ISlotClickHandler.IScrollableSlot::getDisplayName), Comparator.comparing(ISlotClickHandler.IScrollableSlot::getModID).reversed().thenComparing(ISlotClickHandler.IScrollableSlot::getDisplayName)),
        REGISTRY_NAME(MekanismLang.LIST_SORT_REGISTRY_NAME, MekanismLang.LIST_SORT_REGISTRY_NAME_DESC, true, Comparator.comparing(ISlotClickHandler.IScrollableSlot::getRegistryName, ResourceLocation::compareNamespaced).thenComparingLong(ISlotClickHandler.IScrollableSlot::count), Comparator.comparing(ISlotClickHandler.IScrollableSlot::getRegistryName, ResourceLocation::compareNamespaced).reversed().thenComparingLong(ISlotClickHandler.IScrollableSlot::count));

        private final ILangEntry name;
        private final ILangEntry tooltip;
        private final boolean usesCount;
        private final Comparator<ISlotClickHandler.IScrollableSlot> ascendingComparator;
        private final Comparator<ISlotClickHandler.IScrollableSlot> descendingComparator;

        private ListSortType(ILangEntry name, ILangEntry tooltip, boolean usesCount, Comparator<ISlotClickHandler.IScrollableSlot> ascendingComparator) {
            this(name, tooltip, usesCount, ascendingComparator, ascendingComparator.reversed());
        }

        private ListSortType(ILangEntry name, ILangEntry tooltip, boolean usesCount, Comparator<ISlotClickHandler.IScrollableSlot> ascendingComparator, Comparator<ISlotClickHandler.IScrollableSlot> descendingComparator) {
            this.name = name;
            this.tooltip = tooltip;
            this.usesCount = usesCount;
            this.ascendingComparator = ascendingComparator;
            this.descendingComparator = descendingComparator;
        }

        public void sort(List<ISlotClickHandler.IScrollableSlot> list, SortDirection direction) {
            if (!list.isEmpty()) {
                list.sort(direction.isAscending() ? this.ascendingComparator : this.descendingComparator);
            }
        }

        public boolean usesCount() {
            return this.usesCount;
        }

        @Override
        public Component getTooltip() {
            return this.tooltip.translate();
        }

        @Override
        public Component getShortName() {
            return this.name.translate();
        }

        @NotNull
        public Component getTranslatedName() {
            return this.getShortName();
        }
    }

    public static enum SortDirection implements GuiComponents.IToggleEnum<SortDirection>,
    IHasTranslationKey.IHasEnumNameTranslationKey
    {
        ASCENDING(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "arrow_up.png"), MekanismLang.LIST_SORT_ASCENDING, MekanismLang.LIST_SORT_ASCENDING_DESC),
        DESCENDING(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "arrow_down.png"), MekanismLang.LIST_SORT_DESCENDING, MekanismLang.LIST_SORT_DESCENDING_DESC);

        private final ResourceLocation icon;
        private final ILangEntry name;
        private final ILangEntry tooltip;

        private SortDirection(ResourceLocation icon, ILangEntry name, ILangEntry tooltip) {
            this.icon = icon;
            this.name = name;
            this.tooltip = tooltip;
        }

        @Override
        public ResourceLocation getIcon() {
            return this.icon;
        }

        @Override
        public Component getTooltip() {
            return this.tooltip.translate();
        }

        public boolean isAscending() {
            return this == ASCENDING;
        }

        @Override
        @NotNull
        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }
    }

    private static enum SortingNeeded {
        NONE(false, false),
        ITEMS_ONLY(true, false),
        SEARCH_ONLY(false, true),
        ALL(true, true);

        private final boolean sortItems;
        private final boolean sortSearch;

        private SortingNeeded(boolean sortItems, boolean sortSearch) {
            this.sortItems = sortItems;
            this.sortSearch = sortSearch;
        }

        public SortingNeeded concat(SortingNeeded toConcat) {
            boolean sortSearch;
            boolean bl = sortSearch = this.sortSearchList() || toConcat.sortSearchList();
            if (this.sortItemList() || toConcat.sortItemList()) {
                return sortSearch ? ALL : ITEMS_ONLY;
            }
            return sortSearch ? SEARCH_ONLY : NONE;
        }

        public boolean sortItemList() {
            return this.sortItems;
        }

        public boolean sortSearchList() {
            return this.sortSearch;
        }
    }

    public static final class ItemSlotData
    implements ISlotClickHandler.IScrollableSlot {
        private final HashedItem.UUIDAwareHashedItem item;
        private long count;

        public ItemSlotData(HashedItem.UUIDAwareHashedItem item, long count) {
            this.item = item;
            this.count = count;
        }

        @Override
        public HashedItem asRawHashedItem() {
            return this.item.asRawHashedItem();
        }

        @Override
        public HashedItem.UUIDAwareHashedItem item() {
            return this.item;
        }

        @Override
        public UUID itemUUID() {
            return this.item.getUUID();
        }

        @Override
        public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long count() {
            return this.count;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ItemSlotData other = (ItemSlotData)obj;
            return this.count == other.count && this.item.equals(other.item);
        }

        public int hashCode() {
            int result = this.item.hashCode();
            result = 31 * result + Long.hashCode(this.count);
            return result;
        }
    }
}

