/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import java.util.function.Function;
import mekanism.client.render.hud.MekanismStatusOverlay;
import mekanism.common.Mekanism;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IModeItem {
    public void changeMode(@NotNull Player var1, @NotNull ItemStack var2, int var3, DisplayChange var4);

    default public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return slotType == EquipmentSlot.MAINHAND || slotType == EquipmentSlot.OFFHAND;
    }

    @Nullable
    default public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return null;
    }

    public static boolean isModeItem(@NotNull Player player, @NotNull EquipmentSlot slotType) {
        return IModeItem.isModeItem(player, slotType, true);
    }

    public static boolean isModeItem(@NotNull Player player, @NotNull EquipmentSlot slotType, boolean allowRadial) {
        return IModeItem.isModeItem(player.getItemBySlot(slotType), slotType, allowRadial);
    }

    public static boolean isModeItem(@NotNull ItemStack stack, @NotNull EquipmentSlot slotType) {
        return IModeItem.isModeItem(stack, slotType, true);
    }

    public static boolean isModeItem(@NotNull ItemStack stack, @NotNull EquipmentSlot slotType, boolean allowRadial) {
        IModeItem modeItem;
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof IModeItem && (modeItem = (IModeItem)item).supportsSlotType(stack, slotType)) {
            IGenericRadialModeItem radialModeItem;
            return allowRadial || !(modeItem instanceof IGenericRadialModeItem) || (radialModeItem = (IGenericRadialModeItem)modeItem).getRadialData(stack) == null;
        }
        return false;
    }

    public static void displayModeChange(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Mekanism.packetHandler().showModeChange(serverPlayer);
        } else {
            MekanismStatusOverlay.INSTANCE.setTimer();
        }
    }

    public static interface IAttachmentBasedModeItem<MODE>
    extends IModeItem {
        public DataComponentType<MODE> getModeDataType();

        public MODE getDefaultMode();

        default public MODE getMode(ItemStack stack) {
            return (MODE)stack.getOrDefault(this.getModeDataType(), this.getDefaultMode());
        }

        default public void setMode(ItemStack stack, Player player, MODE mode) {
            stack.set(this.getModeDataType(), mode);
        }
    }

    public static enum DisplayChange {
        NONE,
        MAIN_HAND,
        OTHER;


        public <DATA> void sendMessage(Player player, DATA data, Function<DATA, Component> message) {
            if (this == MAIN_HAND) {
                IModeItem.displayModeChange(player);
            } else if (this == OTHER) {
                player.displayClientMessage(message.apply(data), true);
            }
        }
    }
}

