/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import mekanism.common.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class Meltdown {
    private static final int DURATION = 100;
    private final BlockPos minPos;
    private final BlockPos maxPos;
    private final double magnitude;
    private final double chance;
    private final UUID multiblockID;
    private final float radius;
    private int ticksExisted;

    public Meltdown(BlockPos minPos, BlockPos maxPos, double magnitude, double chance, float radius, UUID multiblockID) {
        this(minPos, maxPos, magnitude, chance, radius, multiblockID, 0);
    }

    private Meltdown(BlockPos minPos, BlockPos maxPos, double magnitude, double chance, float radius, UUID multiblockID, int ticksExisted) {
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.magnitude = magnitude;
        this.chance = chance;
        this.radius = radius;
        this.multiblockID = multiblockID;
        this.ticksExisted = ticksExisted;
    }

    @Nullable
    public static Meltdown load(CompoundTag tag) {
        Optional minPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"min");
        Optional maxPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"max");
        if (minPos.isEmpty() || maxPos.isEmpty()) {
            return null;
        }
        return new Meltdown((BlockPos)minPos.get(), (BlockPos)maxPos.get(), tag.getDouble("magnitude"), tag.getDouble("chance"), tag.getFloat("radius"), tag.getUUID("inventory_id"), tag.getInt("age"));
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.put("min", NbtUtils.writeBlockPos((BlockPos)this.minPos));
        tag.put("max", NbtUtils.writeBlockPos((BlockPos)this.maxPos));
        tag.putDouble("magnitude", this.magnitude);
        tag.putDouble("chance", this.chance);
        tag.putFloat("radius", this.radius);
        tag.putUUID("inventory_id", this.multiblockID);
        tag.putInt("age", this.ticksExisted);
        return tag;
    }

    public boolean update(ServerLevel world) {
        ++this.ticksExisted;
        if (world.random.nextInt() % 10 == 0 && world.random.nextDouble() < this.magnitude * this.chance) {
            int x = Mth.nextInt((RandomSource)world.random, (int)this.minPos.getX(), (int)this.maxPos.getX());
            int y = Mth.nextInt((RandomSource)world.random, (int)this.minPos.getY(), (int)this.maxPos.getY());
            int z = Mth.nextInt((RandomSource)world.random, (int)this.minPos.getZ(), (int)this.maxPos.getZ());
            Explosion.BlockInteraction mode = world.getGameRules().getBoolean(GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
            this.createExplosion(world, x, y, z, this.radius, true, mode);
        }
        if (!WorldUtils.isBlockLoaded((BlockGetter)world, this.minPos) || !WorldUtils.isBlockLoaded((BlockGetter)world, this.maxPos)) {
            return true;
        }
        return this.ticksExisted >= 100;
    }

    private void createExplosion(ServerLevel world, double x, double y, double z, float radius, boolean causesFire, Explosion.BlockInteraction mode) {
        MeltdownExplosion explosion = new MeltdownExplosion((Level)world, x, y, z, radius, causesFire, mode, this.multiblockID);
        ObjectArrayList toBlow = new ObjectArrayList();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (double)j / 7.5 - 1.0;
                    double d1 = (double)k / 7.5 - 1.0;
                    double d2 = (double)l / 7.5 - 1.0;
                    double d3 = Mth.length((double)d0, (double)d1, (double)d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = x;
                    double d6 = y;
                    double d8 = z;
                    for (float f = radius * (0.7f + world.random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos pos = BlockPos.containing((double)d4, (double)d6, (double)d8);
                        BlockState blockstate = world.getBlockState(pos);
                        FluidState fluidstate = blockstate.getFluidState();
                        if (!blockstate.isAir() || !fluidstate.isEmpty()) {
                            f -= (Math.max(blockstate.getExplosionResistance((BlockGetter)world, pos, (Explosion)explosion), fluidstate.getExplosionResistance((BlockGetter)world, pos, (Explosion)explosion)) + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (double)this.minPos.getX() <= d4 && (double)this.minPos.getY() <= d6 && (double)this.minPos.getZ() <= d8 && d4 <= (double)this.maxPos.getX() && d6 <= (double)this.maxPos.getY() && d8 <= (double)this.maxPos.getZ()) {
                            toBlow.add((Object)pos);
                        }
                        d4 += d0 * 0.3;
                        d6 += d1 * 0.3;
                        d8 += d2 * 0.3;
                    }
                }
            }
        }
        if (!EventHooks.onExplosionStart((Level)world, (Explosion)explosion)) {
            explosion.explode();
            explosion.finalizeExplosion(false);
        }
        Meltdown.syncExplosionToClient(world, explosion);
        Util.shuffle((List)toBlow, (RandomSource)world.random);
        ArrayList drops = new ArrayList();
        for (BlockPos toExplode : toBlow) {
            world.getBlockState(toExplode).onExplosionHit((Level)world, toExplode, (Explosion)explosion, (stack, position) -> Explosion.addOrAppendStack((List)drops, (ItemStack)stack, (BlockPos)position));
        }
        for (Pair pair : drops) {
            Block.popResource((Level)world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private static void syncExplosionToClient(ServerLevel level, Explosion explosion) {
        if (!explosion.interactsWithBlocks()) {
            explosion.clearToBlow();
        }
        Vec3 center = explosion.center();
        for (ServerPlayer player : level.players()) {
            if (!(player.distanceToSqr(center.x, center.y, center.z) < 4096.0)) continue;
            player.connection.send((Packet)new ClientboundExplodePacket(center.x, center.y, center.z, explosion.radius(), explosion.getToBlow(), (Vec3)explosion.getHitPlayers().get(player), explosion.getBlockInteraction(), explosion.getSmallExplosionParticles(), explosion.getLargeExplosionParticles(), explosion.getExplosionSound()));
        }
    }

    public static class MeltdownExplosion
    extends Explosion {
        private final UUID multiblockID;

        private MeltdownExplosion(Level world, double x, double y, double z, float radius, boolean causesFire, Explosion.BlockInteraction mode, UUID multiblockID) {
            super(world, null, x, y, z, radius, causesFire, mode);
            this.multiblockID = multiblockID;
        }

        public UUID getMultiblockID() {
            return this.multiblockID;
        }
    }
}

