/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.function.Supplier;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.entity.robit.RobitContainer;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.container.type.MekanismContainerType;
import mekanism.common.inventory.container.type.MekanismItemContainerType;
import mekanism.common.registration.INamedEntry;
import mekanism.common.registration.MekanismDeferredRegister;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;

public class ContainerTypeDeferredRegister
extends MekanismDeferredRegister<MenuType<?>> {
    public ContainerTypeDeferredRegister(String modid) {
        super(Registries.MENU, modid, ContainerTypeRegistryObject::new);
    }

    private <CONTAINER extends AbstractContainerMenu> ContainerTypeRegistryObject<CONTAINER> createHolder(String name) {
        return new ContainerTypeRegistryObject(ResourceLocation.fromNamespaceAndPath((String)this.getNamespace(), (String)name));
    }

    public <TILE extends TileEntityMekanism> ContainerTypeRegistryObject<MekanismTileContainer<TILE>> register(INamedEntry nameProvider, Class<TILE> tileClass) {
        return this.register(nameProvider.getName(), tileClass);
    }

    public <TILE extends TileEntityMekanism> ContainerTypeRegistryObject<MekanismTileContainer<TILE>> register(String name, Class<TILE> tileClass) {
        ContainerTypeRegistryObject registryObject = this.createHolder(name);
        MekanismContainerType.IMekanismContainerFactory<TileEntityMekanism, MekanismTileContainer> factory = (id, inv, data) -> new MekanismTileContainer<TileEntityMekanism>(registryObject, id, inv, (TileEntityMekanism)data);
        this.register(name, () -> MekanismContainerType.tile(tileClass, factory));
        return registryObject;
    }

    public <TILE extends TileEntityMekanism> ContainerTypeRegistryObject<EmptyTileContainer<TILE>> registerEmpty(INamedEntry nameProvider, Class<TILE> tileClass) {
        return this.registerEmpty(nameProvider.getName(), tileClass);
    }

    public <TILE extends TileEntityMekanism> ContainerTypeRegistryObject<EmptyTileContainer<TILE>> registerEmpty(String name, Class<TILE> tileClass) {
        ContainerTypeRegistryObject registryObject = this.createHolder(name);
        MekanismContainerType.IMekanismContainerFactory<TileEntityMekanism, EmptyTileContainer> factory = (id, inv, data) -> new EmptyTileContainer<TileEntityMekanism>(registryObject, id, inv, (TileEntityMekanism)data);
        this.register(name, () -> MekanismContainerType.tile(tileClass, factory));
        return registryObject;
    }

    public <TILE extends TileEntityMekanism, CONTAINER extends MekanismTileContainer<TILE>> ContainerTypeRegistryObject<CONTAINER> register(INamedEntry nameProvider, Class<TILE> tileClass, MekanismContainerType.IMekanismContainerFactory<TILE, CONTAINER> factory) {
        return this.register(nameProvider.getName(), tileClass, factory);
    }

    public <TILE extends TileEntityMekanism, CONTAINER extends MekanismTileContainer<TILE>> ContainerTypeRegistryObject<CONTAINER> register(String name, Class<TILE> tileClass, MekanismContainerType.IMekanismContainerFactory<TILE, CONTAINER> factory) {
        return this.registerMenu(name, () -> MekanismContainerType.tile(tileClass, factory));
    }

    public <ENTITY extends Entity, CONTAINER extends AbstractContainerMenu> ContainerTypeRegistryObject<CONTAINER> registerEntity(String name, Class<ENTITY> entityClass, MekanismContainerType.IMekanismContainerFactory<ENTITY, CONTAINER> factory) {
        return this.registerMenu(name, () -> MekanismContainerType.entity(entityClass, factory));
    }

    public ContainerTypeRegistryObject<RobitContainer> register(String name) {
        ContainerTypeRegistryObject<RobitContainer> registryObject = this.createHolder(name);
        MekanismContainerType.IMekanismContainerFactory<EntityRobit, RobitContainer> factory = (id, inv, data) -> new RobitContainer((ContainerTypeRegistryObject<?>)registryObject, id, inv, (EntityRobit)data);
        this.register(name, () -> MekanismContainerType.entity(EntityRobit.class, factory));
        return registryObject;
    }

    public <ITEM extends Item, CONTAINER extends AbstractContainerMenu> ContainerTypeRegistryObject<CONTAINER> register(INamedEntry nameProvider, Class<ITEM> itemClass, MekanismItemContainerType.IMekanismItemContainerFactory<ITEM, CONTAINER> factory) {
        return this.register(nameProvider.getName(), itemClass, factory);
    }

    public <ITEM extends Item, CONTAINER extends AbstractContainerMenu> ContainerTypeRegistryObject<CONTAINER> register(String name, Class<ITEM> itemClass, MekanismItemContainerType.IMekanismItemContainerFactory<ITEM, CONTAINER> factory) {
        return this.registerMenu(name, () -> MekanismItemContainerType.item(itemClass, factory));
    }

    public <CONTAINER extends AbstractContainerMenu> ContainerTypeRegistryObject<CONTAINER> register(String name, MenuType.MenuSupplier<CONTAINER> factory) {
        return this.registerMenu(name, () -> new MenuType(factory, FeatureFlags.VANILLA_SET));
    }

    public <CONTAINER extends AbstractContainerMenu> ContainerTypeRegistryObject<CONTAINER> register(String name, IContainerFactory<CONTAINER> factory) {
        return this.register(name, (MenuType.MenuSupplier<CONTAINER>)factory);
    }

    public <CONTAINER extends AbstractContainerMenu> ContainerTypeRegistryObject<CONTAINER> register(INamedEntry nameProvider, Supplier<MenuType<CONTAINER>> supplier) {
        return this.registerMenu(nameProvider.getName(), supplier);
    }

    public <CONTAINER extends AbstractContainerMenu> ContainerTypeRegistryObject<CONTAINER> registerMenu(String name, Supplier<MenuType<CONTAINER>> supplier) {
        return (ContainerTypeRegistryObject)super.register(name, supplier);
    }

    public <TILE extends TileEntityMekanism> ContainerBuilder<TILE> custom(INamedEntry nameProvider, Class<TILE> tileClass) {
        return this.custom(nameProvider.getName(), tileClass);
    }

    public <TILE extends TileEntityMekanism> ContainerBuilder<TILE> custom(String name, Class<TILE> tileClass) {
        return new ContainerBuilder<TILE>(name, tileClass);
    }

    public class ContainerBuilder<TILE extends TileEntityMekanism> {
        private final String name;
        private final Class<TILE> tileClass;
        private int offsetX;
        private int offsetY;
        private int armorSlotsX = -1;
        private int armorSlotsY = -1;
        private int offhandOffset = -1;

        private ContainerBuilder(String name, Class<TILE> tileClass) {
            this.name = name;
            this.tileClass = tileClass;
        }

        public ContainerBuilder<TILE> offset(int offsetX, int offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            return this;
        }

        public ContainerBuilder<TILE> armorSideBar() {
            return this.armorSideBar(-20, 67, 0);
        }

        public ContainerBuilder<TILE> armorSideBar(int armorSlotsX, int armorSlotsY) {
            return this.armorSideBar(armorSlotsX, armorSlotsY, -1);
        }

        public ContainerBuilder<TILE> armorSideBar(int armorSlotsX, int armorSlotsY, int offhandOffset) {
            this.armorSlotsX = armorSlotsX;
            this.armorSlotsY = armorSlotsY;
            this.offhandOffset = offhandOffset;
            return this;
        }

        public ContainerTypeRegistryObject<MekanismTileContainer<TILE>> build() {
            ContainerTypeRegistryObject<MekanismTileContainer<TILE>> registryObject = ContainerTypeDeferredRegister.this.createHolder(this.name);
            MekanismContainerType.IMekanismContainerFactory<TileEntityMekanism, MekanismTileContainer> factory = (id, inv, data) -> new MekanismTileContainer<TILE>(registryObject, id, inv, (TileEntityMekanism)data){

                @Override
                protected int getInventoryXOffset() {
                    return super.getInventoryXOffset() + ContainerBuilder.this.offsetX;
                }

                @Override
                protected int getInventoryYOffset() {
                    return super.getInventoryYOffset() + ContainerBuilder.this.offsetY;
                }

                @Override
                protected void addInventorySlots(@NotNull Inventory inv) {
                    super.addInventorySlots(inv);
                    if (ContainerBuilder.this.armorSlotsX != -1 && ContainerBuilder.this.armorSlotsY != -1) {
                        this.addArmorSlots(inv, ContainerBuilder.this.armorSlotsX, ContainerBuilder.this.armorSlotsY, ContainerBuilder.this.offhandOffset);
                    }
                }
            };
            ContainerTypeDeferredRegister.this.register(this.name, () -> MekanismContainerType.tile(this.tileClass, factory));
            return registryObject;
        }
    }
}

