/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import java.util.List;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public interface ISideConfiguration {
    public TileComponentConfig getConfig();

    public Direction getDirection();

    public TileComponentEjector getEjector();

    @Nullable
    default public DataType getActiveDataType(Object container) {
        List<DataType> types;
        int count;
        ConfigInfo info = null;
        TileComponentConfig config = this.getConfig();
        if (container instanceof IChemicalTank && config.supports(TransmissionType.CHEMICAL)) {
            info = config.getConfig(TransmissionType.CHEMICAL);
        } else if (container instanceof IExtendedFluidTank && config.supports(TransmissionType.FLUID)) {
            info = config.getConfig(TransmissionType.FLUID);
        } else if (container instanceof IInventorySlot && config.supports(TransmissionType.ITEM)) {
            info = config.getConfig(TransmissionType.ITEM);
        }
        if (info != null && (count = (types = info.getDataTypeForContainer(container)).size()) > 0 && count < info.getSupportedDataTypes().size()) {
            return types.getFirst();
        }
        return null;
    }
}

